/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.handle;

import com.github.theword.queqiao.QueQiao;
import com.github.theword.queqiao.tool.handle.HandleApiService;
import com.github.theword.queqiao.tool.response.PrivateMessageResponse;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.PaperTool;
import com.google.gson.JsonElement;
import java.time.Duration;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.util.Ticks;
import org.bukkit.entity.Player;

public class HandleApiImpl
implements HandleApiService {
    @Override
    public void handleBroadcastMessage(JsonElement jsonElement) {
        Component prefix = PaperTool.buildComponent((JsonElement)Tool.getPrefixComponent());
        Component message = PaperTool.buildComponent(jsonElement);
        Component result = prefix.append(message);
        QueQiao.instance.getServer().sendMessage(result);
    }

    @Override
    public void handleSendTitleMessage(JsonElement titleJsonElement, JsonElement subtitleJsonElement, int fadein, int stay, int fadeout) {
        TextComponent title = Component.empty();
        TextComponent subtitle = Component.empty();
        if (titleJsonElement != null && !titleJsonElement.isJsonNull()) {
            title = PaperTool.buildComponent(titleJsonElement);
        }
        if (subtitleJsonElement != null && !subtitleJsonElement.isJsonNull()) {
            subtitle = PaperTool.buildComponent(subtitleJsonElement);
        }
        Title.Times times = Title.Times.of((Duration)Ticks.duration((long)fadein), (Duration)Ticks.duration((long)stay), (Duration)Ticks.duration((long)fadeout));
        QueQiao.instance.getServer().showTitle(Title.title((Component)title, (Component)subtitle, (Title.Times)times));
    }

    @Override
    public PrivateMessageResponse handleSendPrivateMessage(String nickname, UUID uuid, JsonElement jsonElement) {
        Player targetPlayer;
        if (uuid != null) {
            targetPlayer = QueQiao.instance.getServer().getPlayer(uuid);
        } else if (nickname != null && !nickname.isEmpty()) {
            targetPlayer = QueQiao.instance.getServer().getPlayer(nickname);
        } else {
            return PrivateMessageResponse.playerNotFound();
        }
        if (targetPlayer == null) {
            return PrivateMessageResponse.playerIsNull();
        }
        if (!targetPlayer.isOnline()) {
            return PrivateMessageResponse.playerNotOnline();
        }
        Component prefix = PaperTool.buildComponent((JsonElement)Tool.getPrefixComponent());
        Component message = PaperTool.buildComponent(jsonElement);
        Component textComponent = prefix.append(message);
        targetPlayer.sendMessage(textComponent);
        return PrivateMessageResponse.sendSuccess(PaperTool.getPaperPlayer(targetPlayer));
    }

    @Override
    public void handleSendActionBarMessage(JsonElement jsonElement) {
        Component message = PaperTool.buildComponent(jsonElement);
        QueQiao.instance.getServer().sendActionBar(message);
    }
}

