/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao;

import com.github.theword.queqiao.Queqiao;
import com.github.theword.queqiao.tool.GlobalContext;
import com.github.theword.queqiao.tool.event.PlayerAchievementEvent;
import com.github.theword.queqiao.tool.event.PlayerChatEvent;
import com.github.theword.queqiao.tool.event.PlayerCommandEvent;
import com.github.theword.queqiao.tool.event.PlayerDeathEvent;
import com.github.theword.queqiao.tool.event.PlayerJoinEvent;
import com.github.theword.queqiao.tool.event.PlayerQuitEvent;
import com.github.theword.queqiao.tool.event.base.BaseEvent;
import com.github.theword.queqiao.tool.event.model.PlayerModel;
import com.github.theword.queqiao.tool.event.model.achievement.AchievementModel;
import com.github.theword.queqiao.tool.event.model.death.DeathModel;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.NeoForgeTool;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.CommandEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class EventProcessor {
    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerChat()) {
            return;
        }
        PlayerModel player = NeoForgeTool.getNeoForgePlayer(event.getPlayer());
        Component message = event.getMessage();
        String rawMessage = Component.Serializer.toJson((Component)message, (HolderLookup.Provider)Queqiao.minecraftServer.registryAccess());
        PlayerChatEvent NeoForgeServerChatEvent = new PlayerChatEvent(player, "", rawMessage, message.getString());
        GlobalContext.sendEvent((BaseEvent)NeoForgeServerChatEvent);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerJoin()) {
            return;
        }
        PlayerModel player = NeoForgeTool.getNeoForgePlayer((ServerPlayer)event.getEntity());
        PlayerJoinEvent forgePlayerLoggedInEvent = new PlayerJoinEvent(player);
        GlobalContext.sendEvent((BaseEvent)forgePlayerLoggedInEvent);
    }

    @SubscribeEvent
    public void onPlayerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerQuit()) {
            return;
        }
        PlayerModel player = NeoForgeTool.getNeoForgePlayer((ServerPlayer)event.getEntity());
        PlayerQuitEvent forgePlayerLoggedOutEvent = new PlayerQuitEvent(player);
        GlobalContext.sendEvent((BaseEvent)forgePlayerLoggedOutEvent);
    }

    @SubscribeEvent
    public void onPlayerCommand(CommandEvent event) {
        PlayerModel player;
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerCommand()) {
            return;
        }
        ParseResults parseResults = event.getParseResults();
        if (!((CommandSourceStack)parseResults.getContext().getSource()).isPlayer()) {
            return;
        }
        String command = Tool.isRegisterOrLoginCommand((String)parseResults.getReader().getString());
        if (command.isEmpty()) {
            return;
        }
        try {
            player = NeoForgeTool.getNeoForgePlayer(((CommandSourceStack)parseResults.getContext().getSource()).getPlayerOrException());
        }
        catch (CommandSyntaxException e) {
            return;
        }
        PlayerCommandEvent forgeCommandEvent = new PlayerCommandEvent(player, "", parseResults.getContext().toString(), command);
        GlobalContext.sendEvent((BaseEvent)forgeCommandEvent);
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerDeath()) {
            return;
        }
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        PlayerModel player = NeoForgeTool.getNeoForgePlayer((ServerPlayer)event.getEntity());
        LivingEntity entity = event.getEntity();
        DeathModel deathModel = new DeathModel();
        Component localizedDeathMessage = event.getSource().getLocalizedDeathMessage(entity);
        ComponentContents componentContents = localizedDeathMessage.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            deathModel.setKey(translatableContents.getKey());
            String[] args = (String[])Arrays.stream(translatableContents.getArgs()).map(obj -> {
                if (obj instanceof Component) {
                    Component component = (Component)obj;
                    return component.getString();
                }
                return String.valueOf(obj);
            }).toArray(String[]::new);
            deathModel.setArgs((Object)args);
        }
        deathModel.setText(localizedDeathMessage.getString());
        PlayerDeathEvent forgeCommandEvent = new PlayerDeathEvent(player, deathModel);
        GlobalContext.sendEvent((BaseEvent)forgeCommandEvent);
    }

    @SubscribeEvent
    public void onPlayerAdvancement(AdvancementEvent.AdvancementEarnEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerAdvancement()) {
            return;
        }
        Advancement advancement = event.getAdvancement().value();
        if (advancement.display().isEmpty() || !((DisplayInfo)advancement.display().get()).shouldAnnounceChat() || advancement.name().isEmpty()) {
            return;
        }
        PlayerModel neoForgePlayer = NeoForgeTool.getNeoForgePlayer((ServerPlayer)event.getEntity());
        AchievementModel achievementModel = NeoForgeTool.getNeoForgeAchievement(advancement);
        achievementModel.setKey(event.getAdvancement().id().toString());
        achievementModel.setText(neoForgePlayer.getNickname() + " has made the advancement " + ((Component)advancement.name().get()).getString());
        PlayerAchievementEvent playerAchievementEvent = new PlayerAchievementEvent(neoForgePlayer, achievementModel);
        GlobalContext.sendEvent((BaseEvent)playerAchievementEvent);
    }
}

