/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.handle;

import com.github.theword.queqiao.Queqiao;
import com.github.theword.queqiao.tool.event.model.PlayerModel;
import com.github.theword.queqiao.tool.handle.HandleApiService;
import com.github.theword.queqiao.tool.response.PrivateMessageResponse;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.NeoForgeTool;
import com.google.gson.JsonElement;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.server.level.ServerPlayer;

public class HandleApiImpl
implements HandleApiService {
    public void handleBroadcastMessage(JsonElement jsonElement) {
        MutableComponent mutableComponent = Component.Serializer.fromJson((JsonElement)Tool.getPrefixComponent(), (HolderLookup.Provider)Queqiao.minecraftServer.registryAccess());
        assert (mutableComponent != null);
        MutableComponent message = Component.Serializer.fromJson((JsonElement)jsonElement, (HolderLookup.Provider)Queqiao.minecraftServer.registryAccess());
        if (message != null) {
            mutableComponent = mutableComponent.copy();
            mutableComponent.append((Component)message);
        }
        this.sendPacket((Packet<?>)new ClientboundSystemChatPacket((Component)mutableComponent, false));
    }

    public void handleSendTitleMessage(JsonElement titleJsonElement, JsonElement subtitleJsonElement, int fadein, int stay, int fadeout) {
        MutableComponent subtitle;
        MutableComponent title;
        this.sendPacket((Packet<?>)new ClientboundSetTitlesAnimationPacket(fadein, stay, fadeout));
        if (titleJsonElement != null && !titleJsonElement.isJsonNull() && (title = Component.Serializer.fromJson((JsonElement)titleJsonElement, (HolderLookup.Provider)Queqiao.minecraftServer.registryAccess())) != null) {
            this.sendPacket((Packet<?>)new ClientboundSetTitleTextPacket((Component)title));
        }
        if (subtitleJsonElement != null && !subtitleJsonElement.isJsonNull() && (subtitle = Component.Serializer.fromJson((JsonElement)subtitleJsonElement, (HolderLookup.Provider)Queqiao.minecraftServer.registryAccess())) != null) {
            this.sendPacket((Packet<?>)new ClientboundSetSubtitleTextPacket((Component)subtitle));
        }
    }

    public void handleSendActionBarMessage(JsonElement jsonElement) {
        MutableComponent mutableComponent = Component.Serializer.fromJson((JsonElement)jsonElement, (HolderLookup.Provider)Queqiao.minecraftServer.registryAccess());
        if (mutableComponent == null) {
            return;
        }
        this.sendPacket((Packet<?>)new ClientboundSetActionBarTextPacket((Component)mutableComponent));
    }

    public PrivateMessageResponse handleSendPrivateMessage(String nickname, UUID uuid, JsonElement jsonElement) {
        ServerPlayer targetPlayer;
        if (uuid != null) {
            targetPlayer = Queqiao.minecraftServer.getPlayerList().getPlayer(uuid);
        } else if (nickname != null && !nickname.isEmpty()) {
            targetPlayer = Queqiao.minecraftServer.getPlayerList().getPlayerByName(nickname);
        } else {
            return PrivateMessageResponse.playerNotFound();
        }
        if (targetPlayer == null) {
            return PrivateMessageResponse.playerIsNull();
        }
        if (targetPlayer.hasDisconnected()) {
            return PrivateMessageResponse.playerNotOnline();
        }
        MutableComponent mutableComponent = Component.Serializer.fromJson((JsonElement)Tool.getPrefixComponent(), (HolderLookup.Provider)Queqiao.minecraftServer.registryAccess());
        assert (mutableComponent != null);
        MutableComponent message = Component.Serializer.fromJson((JsonElement)jsonElement, (HolderLookup.Provider)Queqiao.minecraftServer.registryAccess());
        if (message != null) {
            mutableComponent = mutableComponent.copy();
            mutableComponent.append((Component)message);
        }
        targetPlayer.sendSystemMessage((Component)mutableComponent);
        return PrivateMessageResponse.sendSuccess((PlayerModel)NeoForgeTool.getNeoForgePlayer(targetPlayer));
    }

    private void sendPacket(Packet<?> packet) {
        for (ServerPlayer serverPlayer : Queqiao.minecraftServer.getPlayerList().getPlayers()) {
            serverPlayer.connection.send(packet);
        }
    }
}

