/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao;

import com.github.theword.queqiao.event.forge.ForgeCommandEvent;
import com.github.theword.queqiao.event.forge.ForgePlayerDeathEvent;
import com.github.theword.queqiao.event.forge.ForgePlayerLoggedInEvent;
import com.github.theword.queqiao.event.forge.ForgePlayerLoggedOutEvent;
import com.github.theword.queqiao.event.forge.ForgeServerChatEvent;
import com.github.theword.queqiao.event.forge.ForgeServerPlayer;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.GlobalContext;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.ForgeTool;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class EventProcessor {
    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerChat()) {
            return;
        }
        ForgeServerPlayer player = ForgeTool.getForgePlayer(event.player);
        ForgeServerChatEvent forgeServerChatEvent = new ForgeServerChatEvent("", player, event.message);
        GlobalContext.getWebsocketManager().sendEvent(forgeServerChatEvent);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerJoin()) {
            return;
        }
        ForgeServerPlayer player = ForgeTool.getForgePlayer((EntityPlayerMP)event.player);
        ForgePlayerLoggedInEvent forgePlayerLoggedInEvent = new ForgePlayerLoggedInEvent(player);
        GlobalContext.getWebsocketManager().sendEvent(forgePlayerLoggedInEvent);
    }

    @SubscribeEvent
    public void onPlayerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerQuit()) {
            return;
        }
        ForgeServerPlayer player = ForgeTool.getForgePlayer((EntityPlayerMP)event.player);
        ForgePlayerLoggedOutEvent forgePlayerLoggedOutEvent = new ForgePlayerLoggedOutEvent(player);
        GlobalContext.getWebsocketManager().sendEvent(forgePlayerLoggedOutEvent);
    }

    @SubscribeEvent
    public void onPlayerCommand(CommandEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerCommand()) {
            return;
        }
        if (!(event.sender instanceof EntityPlayerMP)) {
            return;
        }
        String command = Tool.isRegisterOrLoginCommand(event.command.toString());
        if (command.isEmpty()) {
            return;
        }
        ForgeServerPlayer player = ForgeTool.getForgePlayer((EntityPlayerMP)event.sender);
        ForgeCommandEvent forgeCommandEvent = new ForgeCommandEvent("", player, command);
        GlobalContext.getWebsocketManager().sendEvent(forgeCommandEvent);
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerDeath()) {
            return;
        }
        if (!(event.entityLiving instanceof EntityPlayerMP)) {
            return;
        }
        ForgeServerPlayer player = ForgeTool.getForgePlayer((EntityPlayerMP)event.entityLiving);
        String reason = event.source.func_151519_b(event.entityLiving).func_150260_c();
        ForgePlayerDeathEvent forgeCommandEvent = new ForgePlayerDeathEvent("", player, reason);
        GlobalContext.getWebsocketManager().sendEvent(forgeCommandEvent);
    }
}

