/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.config;

import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.config.Config;
import com.github.theword.queqiao.shadow.org.apache.commons.io.FileUtils;
import com.github.theword.queqiao.shadow.org.slf4j.Logger;
import com.github.theword.queqiao.shadow.org.yaml.snakeyaml.Yaml;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public abstract class CommonConfig {
    private final Logger logger;

    public CommonConfig(Logger logger) {
        this.logger = logger;
    }

    protected void readConfigFile(String configFolder, String fileName) {
        Path configPath = Paths.get("./" + configFolder, "QueQiao", fileName);
        this.checkFileExists(configPath, fileName);
        this.readConfigValues(configPath, fileName);
    }

    protected void readConfigValues(Path path, String fileName) {
        this.logger.info("\u6b63\u5728\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6 {}...", (Object)fileName);
        try {
            Yaml yaml = new Yaml();
            BufferedReader reader = Files.newBufferedReader(path);
            Map configMap = (Map)yaml.load(reader);
            this.loadConfigValues(configMap);
            this.logger.info("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6 {} \u6210\u529f\u3002", (Object)fileName);
        }
        catch (IOException exception) {
            this.logger.warn("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6 {} \u5931\u8d25\u3002", (Object)fileName);
            this.logger.warn(exception.getMessage());
            this.logger.warn("\u5c06\u76f4\u63a5\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e\u9879\u3002");
        }
    }

    protected abstract void loadConfigValues(Map<String, Object> var1);

    protected void checkFileExists(Path path, String fileName) {
        this.logger.info("\u6b63\u5728\u5bfb\u627e\u914d\u7f6e\u6587\u4ef6 {}...", (Object)fileName);
        this.logger.info("\u914d\u7f6e\u6587\u4ef6 {} \u8def\u5f84\u4e3a\uff1a{}\u3002", (Object)fileName, (Object)path.toAbsolutePath());
        if (Files.exists(path, new LinkOption[0])) {
            this.logger.info("\u914d\u7f6e\u6587\u4ef6 {} \u5df2\u5b58\u5728\uff0c\u5c06\u8bfb\u53d6\u914d\u7f6e\u9879\u3002", (Object)fileName);
        } else {
            this.logger.warn("\u914d\u7f6e\u6587\u4ef6 {} \u4e0d\u5b58\u5728\uff0c\u5c06\u751f\u6210\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u3002", (Object)fileName);
            try {
                InputStream inputStream = Config.class.getClassLoader().getResourceAsStream(fileName);
                assert (inputStream != null);
                FileUtils.copyInputStreamToFile(inputStream, path.toFile());
                this.logger.info("\u5df2\u751f\u6210\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u3002");
            }
            catch (IOException e) {
                this.logger.warn("\u751f\u6210\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\u3002");
            }
        }
    }
}

