/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.shadow.org.glavo.rcon;

import com.github.theword.queqiao.shadow.org.glavo.rcon.AuthenticationException;
import com.github.theword.queqiao.shadow.org.glavo.rcon.RconPacket;
import java.io.Closeable;
import java.io.Console;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;

public final class Rcon
implements Closeable {
    public static final int DEFAULT_PORT = 25575;
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final ReentrantLock lock = new ReentrantLock();
    private final Random rand = new Random();
    private int requestId;
    private Socket socket;
    private Charset charset = DEFAULT_CHARSET;
    private int timeout = 0;

    public Rcon() {
    }

    public Rcon(String host, String password) throws IOException, AuthenticationException {
        this(host, 25575, password.getBytes(DEFAULT_CHARSET));
    }

    public Rcon(String host, byte[] password) throws IOException, AuthenticationException {
        this(host, 25575, password);
    }

    public Rcon(String host, int port, String password) throws IOException, AuthenticationException {
        this(host, port, password.getBytes(DEFAULT_CHARSET));
    }

    public Rcon(String host, int port, byte[] password) throws IOException, AuthenticationException {
        this.connect(host, port, password);
    }

    public void connect(SocketAddress address, byte[] password) throws IOException, AuthenticationException {
        this.lock.lock();
        try {
            this.requestId = this.rand.nextInt();
            this.socket = new Socket();
            this.socket.connect(address, this.timeout);
            if (this.timeout > 0) {
                this.socket.setSoTimeout(this.timeout);
            }
        }
        finally {
            this.lock.unlock();
        }
        RconPacket res = this.send(3, password);
        if (res.getRequestId() == -1) {
            throw new AuthenticationException("Password rejected by server");
        }
    }

    public void connect(String host, int port, byte[] password) throws IOException, AuthenticationException {
        this.connect(new InetSocketAddress(host, port), password);
    }

    public void disconnect() throws IOException {
        this.lock.lock();
        try {
            this.socket.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }

    public String command(String payload) throws IOException {
        if (payload == null || payload.trim().isEmpty()) {
            throw new IllegalArgumentException("Payload can't be null or empty");
        }
        byte[] bytes = payload.getBytes(this.charset);
        if (bytes.length > 1446) {
            throw new IllegalArgumentException("Payload too long");
        }
        RconPacket response = this.send(2, bytes);
        return new String(response.getPayload(), this.charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RconPacket send(int type, byte[] payload) throws IOException {
        this.lock.lock();
        try {
            RconPacket rconPacket = RconPacket.send(this, type, payload);
            return rconPacket;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getRequestId() {
        return this.requestId;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset == null ? DEFAULT_CHARSET : charset;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public static void main(String[] args) {
        char[] pws;
        Console console = System.console();
        if (console == null) {
            System.err.println("Unable to obtain the Console instance, please run it in the terminal!");
            System.exit(-1);
        }
        String ans = console.readLine("The server IP or domain name (default 127.0.0.1): ", new Object[0]);
        String ip = "127.0.0.1";
        if (ans == null) {
            return;
        }
        if (!ans.isEmpty()) {
            try {
                ip = InetAddress.getByName(ans.trim()).getHostAddress();
            }
            catch (UnknownHostException e) {
                System.err.println("Name or service not known: " + ans);
                System.exit(-1);
            }
        }
        String ps = console.readLine("The RCON network port (defaule 25575): ", new Object[0]);
        int port = 25575;
        if (ps == null) {
            return;
        }
        if (!ps.isEmpty()) {
            try {
                port = Integer.parseInt(ps.trim());
                if (port < 1 || port > 65535) {
                    System.err.println("Port " + port + " is out of range");
                    System.exit(-1);
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Wrong port: " + ps);
                System.exit(-1);
            }
        }
        if ((pws = console.readPassword("The password for RCON: ", new Object[0])) == null) {
            return;
        }
        ByteBuffer pwsa = DEFAULT_CHARSET.encode(CharBuffer.wrap(pws));
        byte[] password = new byte[pwsa.remaining()];
        System.arraycopy(pwsa.array(), pwsa.position(), password, 0, password.length);
        try (Rcon rcon = new Rcon(ip, port, password);){
            String c;
            System.out.println();
            while ((c = console.readLine("RCON> ", new Object[0])) != null) {
                if (c.isEmpty()) continue;
                if (c.trim().equals("exit")) {
                    break;
                }
                try {
                    String a = rcon.command(c);
                    System.out.println(a);
                    if (a.isEmpty()) continue;
                    System.out.println();
                }
                catch (Throwable e) {
                    System.err.println(e.getMessage());
                    System.err.println();
                }
            }
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        System.out.println("Bye bye!");
    }
}

