/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao;

import com.github.theword.queqiao.tool.GlobalContext;
import com.github.theword.queqiao.tool.event.PlayerAchievementEvent;
import com.github.theword.queqiao.tool.event.PlayerChatEvent;
import com.github.theword.queqiao.tool.event.PlayerCommandEvent;
import com.github.theword.queqiao.tool.event.PlayerDeathEvent;
import com.github.theword.queqiao.tool.event.PlayerJoinEvent;
import com.github.theword.queqiao.tool.event.PlayerQuitEvent;
import com.github.theword.queqiao.tool.event.model.PlayerModel;
import com.github.theword.queqiao.tool.event.model.achievement.AchievementModel;
import com.github.theword.queqiao.tool.event.model.death.DeathModel;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.ForgeTool;
import java.util.Arrays;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class EventProcessor {
    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        try {
            if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerChat()) {
                return;
            }
            PlayerModel player = ForgeTool.getForgePlayer(event.getPlayer());
            ITextComponent.Serializer.func_150696_a((ITextComponent)event.getComponent());
            PlayerChatEvent forgeServerChatEvent = new PlayerChatEvent(player, "", ITextComponent.Serializer.func_150696_a((ITextComponent)event.getComponent()), event.getMessage());
            GlobalContext.sendEvent(forgeServerChatEvent);
        }
        catch (Exception e) {
            GlobalContext.getLogger().error("Error processing ServerChatEvent: ", e);
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        try {
            if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerJoin()) {
                return;
            }
            PlayerModel player = ForgeTool.getForgePlayer((EntityPlayerMP)event.player);
            PlayerJoinEvent forgePlayerLoggedInEvent = new PlayerJoinEvent(player);
            GlobalContext.sendEvent(forgePlayerLoggedInEvent);
        }
        catch (Exception e) {
            GlobalContext.getLogger().error("Error processing PlayerLoggedInEvent: ", e);
        }
    }

    @SubscribeEvent
    public void onPlayerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        try {
            if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerQuit()) {
                return;
            }
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)event.player;
            PlayerModel player = ForgeTool.getForgePlayer(entityPlayerMP);
            PlayerQuitEvent forgePlayerLoggedOutEvent = new PlayerQuitEvent(player);
            GlobalContext.sendEvent(forgePlayerLoggedOutEvent);
        }
        catch (Exception e) {
            GlobalContext.getLogger().error("Error processing PlayerLoggedOutEvent: ", e);
        }
    }

    @SubscribeEvent
    public void onPlayerCommand(CommandEvent event) {
        try {
            if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerCommand()) {
                return;
            }
            if (!(event.getSender() instanceof EntityPlayerMP)) {
                return;
            }
            StringBuilder commandString = new StringBuilder(event.getCommand().func_71517_b());
            for (String parameter : event.getParameters()) {
                commandString.append(" ").append(parameter);
            }
            String command = Tool.isIgnoredCommand(commandString.toString());
            if (command.isEmpty()) {
                return;
            }
            PlayerModel player = ForgeTool.getForgePlayer((EntityPlayerMP)event.getSender());
            PlayerCommandEvent forgeCommandEvent = new PlayerCommandEvent(player, "", command, command);
            GlobalContext.sendEvent(forgeCommandEvent);
        }
        catch (Exception e) {
            GlobalContext.getLogger().error("Error processing CommandEvent: ", e);
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        try {
            if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerDeath()) {
                return;
            }
            if (event.getEntity() == null || !(event.getEntity() instanceof EntityPlayerMP)) {
                return;
            }
            PlayerModel player = ForgeTool.getForgePlayer((EntityPlayerMP)event.getEntity());
            ITextComponent deathMessage = event.getEntityLiving().func_110142_aN().func_151521_b();
            DeathModel deathModel = new DeathModel();
            deathModel.setText(deathMessage.func_150260_c());
            TextComponentTranslation deathMessageTranslation = (TextComponentTranslation)deathMessage;
            deathModel.setKey(deathMessageTranslation.func_150268_i());
            String[] args = (String[])Arrays.stream(deathMessageTranslation.func_150271_j()).map(obj -> {
                if (obj instanceof ITextComponent) {
                    return ((ITextComponent)obj).func_150260_c();
                }
                return String.valueOf(obj);
            }).toArray(String[]::new);
            deathModel.setArgs(args);
            PlayerDeathEvent forgePlayerDeathEvent = new PlayerDeathEvent(player, deathModel);
            GlobalContext.sendEvent(forgePlayerDeathEvent);
        }
        catch (Exception e) {
            GlobalContext.getLogger().error("Error processing LivingDeathEvent: ", e);
        }
    }

    @SubscribeEvent
    public void onPlayerAdvancement(AdvancementEvent event) {
        try {
            if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerAdvancement()) {
                return;
            }
            Advancement advancement = event.getAdvancement();
            if (advancement.func_192068_c() == null || !advancement.func_192068_c().func_193220_i()) {
                return;
            }
            PlayerModel player = ForgeTool.getForgePlayer((EntityPlayerMP)event.getEntityPlayer());
            AchievementModel achievementModel = ForgeTool.getForgeAchievement(advancement);
            achievementModel.pattern(achievementModel.getDisplay().getFrame(), player.getNickname(), advancement.func_193123_j().func_150260_c());
            PlayerAchievementEvent forgeAdvancementEvent = new PlayerAchievementEvent(player, achievementModel);
            GlobalContext.sendEvent(forgeAdvancementEvent);
        }
        catch (Exception e) {
            GlobalContext.getLogger().error("Error processing AdvancementEvent: ", e);
        }
    }
}

