/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.handle;

import com.github.theword.queqiao.QueQiao;
import com.github.theword.queqiao.tool.GlobalContext;
import com.github.theword.queqiao.tool.handle.HandleApiService;
import com.github.theword.queqiao.tool.response.PrivateMessageResponse;
import com.github.theword.queqiao.utils.ForgeTool;
import com.google.gson.JsonElement;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.util.text.ITextComponent;

public class HandleApiImpl
implements HandleApiService {
    @Override
    public void handleBroadcastMessage(JsonElement jsonElement) {
        ITextComponent prefixed = ForgeTool.parseJsonToTextWrapped((JsonElement)GlobalContext.getMessagePrefixJsonObject());
        ITextComponent message = ForgeTool.parseJsonToTextWrapped(jsonElement);
        if (message != null && prefixed != null) {
            for (EntityPlayerMP serverPlayer : QueQiao.minecraftServer.func_184103_al().func_181057_v()) {
                serverPlayer.func_145747_a(prefixed.func_150257_a(message));
            }
        }
    }

    @Override
    public void handleSendTitleMessage(JsonElement titleJsonElement, JsonElement subtitleJsonElement, int fadein, int stay, int fadeout) {
        if (titleJsonElement != null && !titleJsonElement.isJsonNull()) {
            ITextComponent title = ForgeTool.parseJsonToTextWrapped(titleJsonElement);
            this.sendPacket((Packet<?>)new SPacketTitle(SPacketTitle.Type.TITLE, title, fadein, stay, fadeout));
        }
        if (subtitleJsonElement != null && !subtitleJsonElement.isJsonNull()) {
            ITextComponent subtitle = ForgeTool.parseJsonToTextWrapped(subtitleJsonElement);
            this.sendPacket((Packet<?>)new SPacketTitle(SPacketTitle.Type.SUBTITLE, subtitle, fadein, stay, fadeout));
        }
    }

    @Override
    public void handleSendActionBarMessage(JsonElement jsonElement) {
        ITextComponent msg = ForgeTool.parseJsonToTextWrapped(jsonElement);
        if (msg != null) {
            this.sendPacket((Packet<?>)new SPacketTitle(SPacketTitle.Type.ACTIONBAR, msg));
        }
    }

    @Override
    public PrivateMessageResponse handleSendPrivateMessage(String nickname, UUID uuid, JsonElement jsonElement) {
        EntityPlayerMP targetPlayer;
        if (uuid != null) {
            targetPlayer = QueQiao.minecraftServer.func_184103_al().func_177451_a(uuid);
        } else if (nickname != null && !nickname.isEmpty()) {
            targetPlayer = QueQiao.minecraftServer.func_184103_al().func_152612_a(nickname);
        } else {
            return PrivateMessageResponse.playerNotFound();
        }
        if (targetPlayer == null) {
            return PrivateMessageResponse.playerIsNull();
        }
        if (targetPlayer.func_193105_t()) {
            return PrivateMessageResponse.playerNotOnline();
        }
        ITextComponent prefixed = ForgeTool.parseJsonToTextWrapped((JsonElement)GlobalContext.getMessagePrefixJsonObject());
        ITextComponent message = ForgeTool.parseJsonToTextWrapped(jsonElement);
        if (message != null && prefixed != null) {
            targetPlayer.func_145747_a(prefixed.func_150257_a(message));
        }
        return PrivateMessageResponse.sendSuccess(ForgeTool.getForgePlayer(targetPlayer));
    }

    private void sendPacket(Packet<?> packet) {
        for (EntityPlayerMP serverPlayer : QueQiao.minecraftServer.func_184103_al().func_181057_v()) {
            serverPlayer.field_71135_a.func_147359_a(packet);
        }
    }
}

