/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.utils;

import com.github.theword.queqiao.tool.handle.ParseJsonToEventService;
import com.github.theword.queqiao.tool.payload.MessageSegment;
import com.github.theword.queqiao.tool.payload.modle.component.CommonBaseComponent;
import com.github.theword.queqiao.tool.payload.modle.component.CommonTextComponent;
import com.github.theword.queqiao.tool.payload.modle.hover.CommonHoverEntity;
import com.github.theword.queqiao.tool.payload.modle.hover.CommonHoverItem;
import com.github.theword.queqiao.tool.utils.Tool;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ParseJsonToEventImpl
implements ParseJsonToEventService {
    public MutableComponent parseMessageListToComponent(List<MessageSegment> myBaseComponentList) {
        MutableComponent mutableComponent = MutableComponent.m_237204_((ComponentContents)new LiteralContents(""));
        StringBuilder msgLogText = new StringBuilder();
        for (MessageSegment messageSegment : myBaseComponentList) {
            MutableComponent tempMutableComponent = this.parsePerMessageToComponent((CommonBaseComponent)messageSegment.getData());
            mutableComponent.m_7220_((Component)tempMutableComponent);
            msgLogText.append(messageSegment.getData().getText());
        }
        Tool.logger.info(msgLogText.toString());
        return mutableComponent;
    }

    public MutableComponent parseCommonBaseComponentListToComponent(List<CommonBaseComponent> myBaseComponentList) {
        MutableComponent mutableComponent = MutableComponent.m_237204_((ComponentContents)new LiteralContents(""));
        for (CommonBaseComponent commonBaseComponent : myBaseComponentList) {
            MutableComponent tempMutableComponent = this.parsePerMessageToComponent(commonBaseComponent);
            mutableComponent.m_7220_((Component)tempMutableComponent);
        }
        return mutableComponent;
    }

    public MutableComponent parsePerMessageToComponent(CommonBaseComponent myBaseComponent) {
        LiteralContents tempMutableComponent = new LiteralContents(myBaseComponent.getText());
        Style style = this.getStyleFromBaseComponent(myBaseComponent);
        if (myBaseComponent instanceof CommonTextComponent) {
            CommonTextComponent commonTextComponent = (CommonTextComponent)myBaseComponent;
            if (commonTextComponent.getClickEvent() != null) {
                style = style.m_131142_(this.getClickEventFromBaseComponent(commonTextComponent));
            }
            if (commonTextComponent.getHoverEvent() != null) {
                style = style.m_131144_(this.getHoverEventFromBaseComponent(commonTextComponent));
            }
        }
        MutableComponent mutableComponent = MutableComponent.m_237204_((ComponentContents)tempMutableComponent);
        mutableComponent.m_6270_(style);
        return mutableComponent;
    }

    private Style getStyleFromBaseComponent(CommonBaseComponent myBaseComponent) {
        ResourceLocation font = null;
        if (myBaseComponent.getFont() != null) {
            font = new ResourceLocation(myBaseComponent.getFont());
        }
        Style style = Style.f_131099_.m_131136_(Boolean.valueOf(myBaseComponent.isBold())).m_131155_(Boolean.valueOf(myBaseComponent.isItalic())).m_131138_(myBaseComponent.getInsertion()).m_131150_(font).m_131162_(Boolean.valueOf(myBaseComponent.isUnderlined())).m_178522_(Boolean.valueOf(myBaseComponent.isStrikethrough())).m_178524_(Boolean.valueOf(myBaseComponent.isObfuscated()));
        style = myBaseComponent.getColor() != null && !myBaseComponent.getColor().isEmpty() ? style.m_131148_(TextColor.m_131268_((String)myBaseComponent.getColor())) : style.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.WHITE));
        return style;
    }

    private ClickEvent getClickEventFromBaseComponent(CommonTextComponent myTextComponent) {
        if (myTextComponent.getClickEvent() != null) {
            ClickEvent.Action tempAction = ClickEvent.Action.m_130645_((String)myTextComponent.getClickEvent().getAction().toLowerCase());
            return new ClickEvent(tempAction, myTextComponent.getClickEvent().getValue());
        }
        return null;
    }

    public HoverEvent getHoverEventFromBaseComponent(CommonTextComponent myTextComponent) {
        CommonHoverEntity commonHoverEntity;
        Optional entityType;
        HoverEvent hoverEvent = null;
        HoverEvent.Action action = HoverEvent.Action.m_130852_((String)myTextComponent.getHoverEvent().getAction().toLowerCase());
        assert (action != null);
        if (action.equals(HoverEvent.Action.f_130831_)) {
            if (myTextComponent.getHoverEvent().getText() != null && !myTextComponent.getHoverEvent().getText().isEmpty()) {
                MutableComponent textComponent = this.parseCommonBaseComponentListToComponent((List<CommonBaseComponent>)myTextComponent.getHoverEvent().getText());
                hoverEvent = new HoverEvent(HoverEvent.Action.f_130831_, (Object)textComponent);
            }
        } else if (action.equals(HoverEvent.Action.f_130832_)) {
            CommonHoverItem commonHoverItem = myTextComponent.getHoverEvent().getItem();
            Item item = Item.m_41445_((int)Integer.parseInt(commonHoverItem.getId()));
            ItemStack itemStack = new ItemStack((ItemLike)item, commonHoverItem.getCount().intValue());
            HoverEvent.ItemStackInfo itemHover = new HoverEvent.ItemStackInfo(itemStack);
            hoverEvent = new HoverEvent(HoverEvent.Action.f_130832_, (Object)itemHover);
        } else if (action.equals(HoverEvent.Action.f_130833_) && (entityType = EntityType.m_20632_((String)(commonHoverEntity = myTextComponent.getHoverEvent().getEntity()).getType())).isPresent()) {
            HoverEvent.EntityTooltipInfo entityTooltipInfo = new HoverEvent.EntityTooltipInfo((EntityType)entityType.get(), UUID.randomUUID(), (Component)this.parseCommonBaseComponentListToComponent((List<CommonBaseComponent>)commonHoverEntity.getName()));
            hoverEvent = new HoverEvent(HoverEvent.Action.f_130833_, (Object)entityTooltipInfo);
        }
        return hoverEvent;
    }
}

