/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao;

import com.github.theword.queqiao.event.spigot.SpigotAsyncPlayerChatEvent;
import com.github.theword.queqiao.event.spigot.SpigotPlayerAdvancementDoneEvent;
import com.github.theword.queqiao.event.spigot.SpigotPlayerCommandPreprocessEvent;
import com.github.theword.queqiao.event.spigot.SpigotPlayerDeathEvent;
import com.github.theword.queqiao.event.spigot.SpigotPlayerJoinEvent;
import com.github.theword.queqiao.event.spigot.SpigotPlayerQuitEvent;
import com.github.theword.queqiao.event.spigot.dto.advancement.SpigotAdvancement;
import com.github.theword.queqiao.tool.GlobalContext;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.SpigotTool;
import org.bukkit.advancement.Advancement;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

class EventProcessor
implements Listener {
    EventProcessor() {
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void onPlayerChat(AsyncPlayerChatEvent event) {
        if (event.isCancelled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerChat()) {
            return;
        }
        SpigotAsyncPlayerChatEvent spigotAsyncPlayerChatEvent = new SpigotAsyncPlayerChatEvent(SpigotTool.getSpigotPlayer(event.getPlayer()), event.getMessage());
        GlobalContext.sendEvent(spigotAsyncPlayerChatEvent);
    }

    @EventHandler
    void onPlayerDeath(PlayerDeathEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerDeath()) {
            return;
        }
        SpigotPlayerDeathEvent spigotPlayerDeathEvent = new SpigotPlayerDeathEvent(SpigotTool.getSpigotPlayer(event.getEntity()), event.getDeathMessage());
        GlobalContext.sendEvent(spigotPlayerDeathEvent);
    }

    @EventHandler
    void onPlayerJoin(PlayerJoinEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerJoin()) {
            return;
        }
        SpigotPlayerJoinEvent spigotPlayerJoinEvent = new SpigotPlayerJoinEvent(SpigotTool.getSpigotPlayer(event.getPlayer()));
        GlobalContext.sendEvent(spigotPlayerJoinEvent);
    }

    @EventHandler
    void onPlayerQuit(PlayerQuitEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerQuit()) {
            return;
        }
        SpigotPlayerQuitEvent spigotPlayerQuitEvent = new SpigotPlayerQuitEvent(SpigotTool.getSpigotPlayer(event.getPlayer()));
        GlobalContext.sendEvent(spigotPlayerQuitEvent);
    }

    @EventHandler
    void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerCommand()) {
            return;
        }
        String command = Tool.isRegisterOrLoginCommand(event.getMessage());
        if (command.isEmpty()) {
            return;
        }
        SpigotPlayerCommandPreprocessEvent spigotPlayerCommandPreprocessEvent = new SpigotPlayerCommandPreprocessEvent(SpigotTool.getSpigotPlayer(event.getPlayer()), command);
        GlobalContext.sendEvent(spigotPlayerCommandPreprocessEvent);
    }

    @EventHandler
    void onPlayerAdvancement(PlayerAdvancementDoneEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerAdvancement()) {
            return;
        }
        Advancement advancement = event.getAdvancement();
        SpigotAdvancement spigotAdvancement = SpigotTool.getSpigotAdvancement(advancement);
        SpigotPlayerAdvancementDoneEvent spigotPlayerAdvancementDoneEvent = new SpigotPlayerAdvancementDoneEvent(SpigotTool.getSpigotPlayer(event.getPlayer()), spigotAdvancement);
        GlobalContext.sendEvent(spigotPlayerAdvancementDoneEvent);
    }
}

