/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.handle;

import com.github.theword.queqiao.QueQiao;
import com.github.theword.queqiao.tool.handle.HandleApiService;
import com.github.theword.queqiao.tool.response.PrivateMessageResponse;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.SpigotTool;
import com.google.gson.JsonElement;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class HandleApiImpl
implements HandleApiService {
    @Override
    public void handleBroadcastMessage(JsonElement jsonElement) {
        BaseComponent[] prefix = SpigotTool.buildComponent((JsonElement)Tool.getPrefixComponent());
        BaseComponent[] message = SpigotTool.buildComponent(jsonElement);
        TextComponent textComponent = new TextComponent();
        textComponent.addExtra(prefix[0]);
        for (BaseComponent base : message) {
            textComponent.addExtra(base);
        }
        QueQiao.instance.getServer().spigot().broadcast((BaseComponent)textComponent);
    }

    @Override
    public void handleSendTitleMessage(JsonElement titleJsonElement, JsonElement subtitleJsonElement, int fadein, int stay, int fadeout) {
        String titleText = "";
        if (titleJsonElement != null && !titleJsonElement.isJsonNull()) {
            BaseComponent[] title = SpigotTool.buildComponent(titleJsonElement);
            titleText = TextComponent.toLegacyText((BaseComponent[])title);
        }
        String subtitleText = "";
        if (subtitleJsonElement != null && !subtitleJsonElement.isJsonNull()) {
            BaseComponent[] subtitle = SpigotTool.buildComponent(subtitleJsonElement);
            subtitleText = TextComponent.toLegacyText((BaseComponent[])subtitle);
        }
        for (Player player : QueQiao.instance.getServer().getOnlinePlayers()) {
            player.sendTitle(titleText, subtitleText, fadein, stay, fadeout);
        }
    }

    @Override
    public PrivateMessageResponse handleSendPrivateMessage(String nickname, UUID uuid, JsonElement jsonElement) {
        Player targetPlayer;
        if (uuid != null) {
            targetPlayer = QueQiao.instance.getServer().getPlayer(uuid);
        } else if (nickname != null && !nickname.isEmpty()) {
            targetPlayer = QueQiao.instance.getServer().getPlayer(nickname);
        } else {
            return PrivateMessageResponse.playerNotFound();
        }
        if (targetPlayer == null) {
            return PrivateMessageResponse.playerIsNull();
        }
        if (!targetPlayer.isOnline()) {
            return PrivateMessageResponse.playerNotOnline();
        }
        BaseComponent[] prefix = SpigotTool.buildComponent((JsonElement)Tool.getPrefixComponent());
        BaseComponent[] message = SpigotTool.buildComponent(jsonElement);
        TextComponent textComponent = new TextComponent();
        textComponent.addExtra(prefix[0]);
        for (BaseComponent base : message) {
            textComponent.addExtra(base);
        }
        targetPlayer.sendMessage(TextComponent.toLegacyText((BaseComponent[])new BaseComponent[]{textComponent}));
        return PrivateMessageResponse.sendSuccess(SpigotTool.getSpigotPlayer(targetPlayer));
    }

    @Override
    public void handleSendActionBarMessage(JsonElement jsonElement) {
        BaseComponent[] message = SpigotTool.buildComponent(jsonElement);
        for (Player player : QueQiao.instance.getServer().getOnlinePlayers()) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, message);
        }
    }
}

