/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao;

import com.github.theword.queqiao.event.forge.ForgeAdvancementEvent;
import com.github.theword.queqiao.event.forge.ForgeCommandEvent;
import com.github.theword.queqiao.event.forge.ForgePlayerDeathEvent;
import com.github.theword.queqiao.event.forge.ForgePlayerLoggedInEvent;
import com.github.theword.queqiao.event.forge.ForgePlayerLoggedOutEvent;
import com.github.theword.queqiao.event.forge.ForgeServerChatEvent;
import com.github.theword.queqiao.event.forge.ForgeServerPlayer;
import com.github.theword.queqiao.event.forge.dto.advancement.ForgeAdvancement;
import com.github.theword.queqiao.tool.GlobalContext;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.ForgeTool;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.advancements.Advancement;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventProcessor {
    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerChat()) {
            return;
        }
        ForgeServerPlayer player = ForgeTool.getForgePlayer(event.getPlayer());
        String message = event.getMessage();
        ForgeServerChatEvent forgeServerChatEvent = new ForgeServerChatEvent("", player, message);
        GlobalContext.sendEvent(forgeServerChatEvent);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerJoin()) {
            return;
        }
        ForgeServerPlayer player = ForgeTool.getForgePlayer((ServerPlayerEntity)event.getEntity());
        ForgePlayerLoggedInEvent forgePlayerLoggedInEvent = new ForgePlayerLoggedInEvent(player);
        GlobalContext.sendEvent(forgePlayerLoggedInEvent);
    }

    @SubscribeEvent
    public void onPlayerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerQuit()) {
            return;
        }
        ForgeServerPlayer player = ForgeTool.getForgePlayer((ServerPlayerEntity)event.getPlayer());
        ForgePlayerLoggedOutEvent forgePlayerLoggedOutEvent = new ForgePlayerLoggedOutEvent(player);
        GlobalContext.sendEvent(forgePlayerLoggedOutEvent);
    }

    @SubscribeEvent
    public void onPlayerCommand(CommandEvent event) {
        ForgeServerPlayer player;
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerCommand()) {
            return;
        }
        if (!(((CommandSource)event.getParseResults().getContext().getSource()).func_197022_f() instanceof ServerPlayerEntity)) {
            return;
        }
        String command = Tool.isRegisterOrLoginCommand(event.getParseResults().getReader().getString());
        if (command.isEmpty()) {
            return;
        }
        try {
            player = ForgeTool.getForgePlayer(((CommandSource)event.getParseResults().getContext().getSource()).func_197035_h());
        }
        catch (CommandSyntaxException e) {
            return;
        }
        ForgeCommandEvent forgeCommandEvent = new ForgeCommandEvent("", player, command);
        GlobalContext.sendEvent(forgeCommandEvent);
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerDeath()) {
            return;
        }
        if (!(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        ForgeServerPlayer player = ForgeTool.getForgePlayer((ServerPlayerEntity)event.getEntity());
        LivingEntity entity = (LivingEntity)event.getEntity();
        String message = event.getSource().func_151519_b(entity).getString();
        ForgePlayerDeathEvent forgeCommandEvent = new ForgePlayerDeathEvent("", player, message);
        GlobalContext.sendEvent(forgeCommandEvent);
    }

    @SubscribeEvent
    public void onPlayerAdvancement(AdvancementEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerAdvancement()) {
            return;
        }
        Advancement advancement = event.getAdvancement();
        ForgeServerPlayer player = ForgeTool.getForgePlayer((ServerPlayerEntity)event.getPlayer());
        ForgeAdvancement forgeAdvancement = ForgeTool.getForgeAdvancement(advancement);
        ForgeAdvancementEvent forgeAdvancementEvent = new ForgeAdvancementEvent(player, forgeAdvancement);
        GlobalContext.sendEvent(forgeAdvancementEvent);
    }
}

