/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.tool.handle;

import com.github.theword.queqiao.tool.GlobalContext;
import com.github.theword.queqiao.tool.handle.HandleApiService;
import com.github.theword.queqiao.tool.payload.BasePayload;
import com.github.theword.queqiao.tool.payload.CommandPayload;
import com.github.theword.queqiao.tool.payload.MessagePayload;
import com.github.theword.queqiao.tool.payload.PrivateMessagePayload;
import com.github.theword.queqiao.tool.payload.TitlePayload;
import com.github.theword.queqiao.tool.response.PrivateMessageResponse;
import com.github.theword.queqiao.tool.response.Response;
import com.github.theword.queqiao.tool.utils.Tool;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.HashMap;
import org.java_websocket.WebSocket;
import shadow.org.slf4j.Logger;

public class HandleProtocolMessage {
    private final Gson gson;
    private static final HandleApiService handleApiService = GlobalContext.getHandleApiService();
    private final Logger logger;

    public HandleProtocolMessage(Logger logger, Gson gson) {
        this.logger = logger;
        this.gson = gson;
    }

    public String handleWebsocketJson(WebSocket webSocket, String rawJsonMessage) {
        Response response = this.handle(rawJsonMessage, webSocket.getRemoteSocketAddress().toString(), MessageSource.WEBSOCKET);
        return this.gson.toJson((Object)response);
    }

    public String handleHttpJson(String rawJsonMessage) {
        Response response = this.handle(rawJsonMessage, "", MessageSource.HTTP);
        return this.gson.toJson((Object)response);
    }

    private Response handle(String rawJsonMessage, String address, MessageSource source) {
        Tool.debugLog("\u6536\u5230\u6765\u81ea {} \u7684 {} \u6d88\u606f\uff1a{}", address, source.toString(), rawJsonMessage);
        try {
            return this.parseAndHandle(rawJsonMessage);
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u6765\u81ea {} \u7684 webSocket \u6d88\u606f\u65f6\u51fa\u73b0\u95ee\u9898\uff0c\u6d88\u606f\u5185\u5bb9\uff1a {}", (Object)address, (Object)rawJsonMessage);
            this.logger.error("\u9519\u8bef\u4fe1\u606f\uff1a", e);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("rawJsonMessage", rawJsonMessage);
            return Response.failed(500, "\u89e3\u6790\u6d88\u606f\u5931\u8d25", data, null);
        }
    }

    public Response parseAndHandle(String rawJsonMessage) {
        BasePayload basePayload = (BasePayload)this.gson.fromJson(rawJsonMessage, BasePayload.class);
        String api = basePayload.getApi();
        JsonElement data = basePayload.getData();
        String echo = basePayload.getEcho();
        switch (api) {
            case "broadcast": 
            case "send_msg": {
                MessagePayload messagePayload = (MessagePayload)this.gson.fromJson(data, MessagePayload.class);
                handleApiService.handleBroadcastMessage(messagePayload.getMessage());
                return Response.success(null, echo);
            }
            case "send_title": {
                TitlePayload titlePayload = (TitlePayload)this.gson.fromJson(data, TitlePayload.class);
                if ((titlePayload.getTitle() == null || titlePayload.getTitle().isJsonNull()) && (titlePayload.getSubtitle() == null || titlePayload.getSubtitle().isJsonNull())) {
                    return Response.failed(400, "Title and Subtitle cannot both be null", null, echo);
                }
                handleApiService.handleSendTitleMessage(titlePayload.getTitle(), titlePayload.getSubtitle(), titlePayload.getFadeIn(), titlePayload.getStay(), titlePayload.getFadeOut());
                return Response.success(null, echo);
            }
            case "send_actionbar": {
                MessagePayload actionMessagePayload = (MessagePayload)this.gson.fromJson(data, MessagePayload.class);
                handleApiService.handleSendActionBarMessage(actionMessagePayload.getMessage());
                return Response.success(null, echo);
            }
            case "send_private_msg": {
                PrivateMessagePayload privateMessagePayload = (PrivateMessagePayload)this.gson.fromJson(data, PrivateMessagePayload.class);
                if ((privateMessagePayload.getNickname() == null || privateMessagePayload.getNickname().isEmpty()) && privateMessagePayload.getUuid() == null) {
                    return Response.failed(400, PrivateMessageResponse.playerIsNull().getMessage(), PrivateMessageResponse.playerIsNull(), echo);
                }
                PrivateMessageResponse privateMessageResponse = handleApiService.handleSendPrivateMessage(privateMessagePayload.getNickname(), privateMessagePayload.getUuid(), privateMessagePayload.getMessage());
                return Response.success(privateMessageResponse, echo);
            }
            case "send_command": {
                return Response.failed(500, api + " is not supported now", null, echo);
            }
            case "send_rcon_command": {
                CommandPayload commandPayload = (CommandPayload)this.gson.fromJson(data, CommandPayload.class);
                try {
                    String result = GlobalContext.sendRconCommand(commandPayload.getCommand());
                    this.logger.info("\u53d1\u9001 Rcon \u547d\u4ee4: {}", (Object)commandPayload.getCommand());
                    return Response.success(result, echo);
                }
                catch (Exception e) {
                    String errorMessage = e.getMessage() != null ? e.getMessage() : "failed";
                    this.logger.warn("Rcon \u6267\u884c\u547d\u4ee4\u65f6\u51fa\u73b0\u95ee\u9898\uff0c\u547d\u4ee4\u53d1\u9001\u5931\u8d25\uff01{}", (Object)errorMessage);
                    HashMap<String, String> resultData = new HashMap<String, String>();
                    resultData.put("command", commandPayload.getCommand());
                    resultData.put("error", errorMessage);
                    return Response.failed(400, errorMessage, resultData, echo);
                }
            }
        }
        this.logger.warn("\u672a\u77e5\u7684API\uff1a{}", (Object)api);
        return Response.failed(404, "\u672a\u77e5\u7684API\uff1a" + api, null, echo);
    }

    private static enum MessageSource {
        HTTP,
        WEBSOCKET;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

