/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao;

import com.github.theword.queqiao.tool.GlobalContext;
import com.github.theword.queqiao.tool.event.PlayerAchievementEvent;
import com.github.theword.queqiao.tool.event.PlayerChatEvent;
import com.github.theword.queqiao.tool.event.PlayerCommandEvent;
import com.github.theword.queqiao.tool.event.PlayerDeathEvent;
import com.github.theword.queqiao.tool.event.PlayerJoinEvent;
import com.github.theword.queqiao.tool.event.PlayerQuitEvent;
import com.github.theword.queqiao.tool.event.model.achievement.AchievementModel;
import com.github.theword.queqiao.tool.event.model.death.DeathModel;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.SpigotTool;
import org.bukkit.advancement.Advancement;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

class EventProcessor
implements Listener {
    EventProcessor() {
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void onPlayerChat(AsyncPlayerChatEvent event) {
        if (event.isCancelled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerChat()) {
            return;
        }
        String message = event.getMessage();
        PlayerChatEvent spigotAsyncPlayerChatEvent = new PlayerChatEvent(SpigotTool.getSpigotPlayer(event.getPlayer()), "", message, message);
        GlobalContext.sendEvent(spigotAsyncPlayerChatEvent);
    }

    @EventHandler
    void onPlayerDeath(org.bukkit.event.entity.PlayerDeathEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerDeath()) {
            return;
        }
        DeathModel deathModel = new DeathModel();
        deathModel.setText(event.getDeathMessage());
        PlayerDeathEvent spigotPlayerDeathEvent = new PlayerDeathEvent(SpigotTool.getSpigotPlayer(event.getEntity()), deathModel);
        GlobalContext.sendEvent(spigotPlayerDeathEvent);
    }

    @EventHandler
    void onPlayerJoin(org.bukkit.event.player.PlayerJoinEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerJoin()) {
            return;
        }
        PlayerJoinEvent spigotPlayerJoinEvent = new PlayerJoinEvent(SpigotTool.getSpigotPlayer(event.getPlayer()));
        GlobalContext.sendEvent(spigotPlayerJoinEvent);
    }

    @EventHandler
    void onPlayerQuit(org.bukkit.event.player.PlayerQuitEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerQuit()) {
            return;
        }
        PlayerQuitEvent spigotPlayerQuitEvent = new PlayerQuitEvent(SpigotTool.getSpigotPlayer(event.getPlayer()));
        GlobalContext.sendEvent(spigotPlayerQuitEvent);
    }

    @EventHandler
    void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerCommand()) {
            return;
        }
        String command = Tool.isRegisterOrLoginCommand(event.getMessage());
        if (command.isEmpty()) {
            return;
        }
        PlayerCommandEvent spigotPlayerCommandPreprocessEvent = new PlayerCommandEvent(SpigotTool.getSpigotPlayer(event.getPlayer()), "", command, command);
        GlobalContext.sendEvent(spigotPlayerCommandPreprocessEvent);
    }

    @EventHandler
    void onPlayerAdvancement(PlayerAdvancementDoneEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerAdvancement()) {
            return;
        }
        Advancement advancement = event.getAdvancement();
        AchievementModel achievementModel = SpigotTool.getSpigotAdvancement(advancement);
        PlayerAchievementEvent spigotPlayerAdvancementDoneEvent = new PlayerAchievementEvent(SpigotTool.getSpigotPlayer(event.getPlayer()), achievementModel);
        GlobalContext.sendEvent(spigotPlayerAdvancementDoneEvent);
    }
}

