/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.tool.websocket;

import com.github.theword.queqiao.tool.handle.HandleProtocolMessage;
import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;

public class WsClient
extends WebSocketClient {
    private final Logger logger;
    private final boolean enabled;
    private final HandleProtocolMessage handleProtocolMessage;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final int reconnectMaxTimes;
    private final int reconnectInterval;
    private final AtomicInteger reconnectTimes = new AtomicInteger(0);
    private volatile boolean stopped = false;

    public WsClient(URI uri, Logger logger, Gson gson, String serverName, String accessToken, int reconnectMaxTimes, int reconnectInterval, boolean enabled) {
        super(uri);
        this.logger = logger;
        this.reconnectMaxTimes = reconnectMaxTimes;
        this.reconnectInterval = reconnectInterval;
        this.enabled = enabled;
        this.handleProtocolMessage = new HandleProtocolMessage(logger, gson);
        try {
            this.addHeader("x-self-name", URLEncoder.encode(serverName, StandardCharsets.UTF_8.toString()));
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("WebSocket \u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25\uff0c\u670d\u52a1\u5668\u540d\u79f0\u7f16\u7801\u5f02\u5e38", e);
        }
        this.addHeader("x-client-origin", "minecraft");
        if (!accessToken.isEmpty()) {
            this.addHeader("Authorization", "Bearer " + accessToken);
        }
    }

    @Override
    public void onOpen(ServerHandshake serverHandshake) {
        this.logger.info("\u5df2\u6210\u529f\u8fde\u63a5\u81f3 {} \u7684 WebSocket \u670d\u52a1\u5668\uff01", (Object)this.getURI());
        this.reconnectTimes.set(0);
    }

    @Override
    public void onMessage(String message) {
        String response;
        if (this.enabled && (response = this.handleProtocolMessage.handleWebsocketJson(this, message)) != null && !response.isEmpty()) {
            this.send(response);
        }
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        this.logger.warn("\u8fde\u63a5\u81f3\uff1a{} \u7684 WebSocket Client \u6b63\u5728\u5173\u95ed\uff0cCode {}\uff0cReason\uff1a{}\u3002", this.getURI(), code, reason);
        if (remote) {
            this.scheduleReconnect(this.nextDelay());
        }
    }

    @Override
    public void onError(Exception exception) {
        this.logger.warn("\u8fde\u63a5\u81f3\uff1a{} \u7684 WebSocket \u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\uff1a{}", this.getURI(), exception.getMessage(), exception);
        this.scheduleReconnect(this.nextDelay());
    }

    private long nextDelay() {
        return Math.min((long)this.reconnectInterval * (1L << this.reconnectTimes.get()), 60L);
    }

    private void scheduleReconnect(long delaySeconds) {
        if (this.stopped || this.reconnectTimes.get() >= this.reconnectMaxTimes) {
            this.logger.info("\u8fde\u63a5\u81f3\uff1a{} \u7684 \u91cd\u8fde\u6b21\u6570\u8fbe\u5230\u6700\u5927\u503c\uff0c\u5c06\u4e0d\u518d\u81ea\u52a8\u91cd\u8fde\uff0c\u8bf7\u4f7f\u7528\u547d\u4ee4\u624b\u52a8\u91cd\u8fde\uff01", (Object)this.getURI());
            return;
        }
        this.reconnectTimes.incrementAndGet();
        this.logger.warn("\u8fde\u63a5\u81f3\uff1a{} \u7684 WebSocket \u8fde\u63a5\u5df2\u65ad\u5f00\uff0c\u5c1d\u8bd5\u7b2c {} \u6b21\u91cd\u8fde...", (Object)this.getURI(), (Object)this.reconnectTimes);
        this.scheduler.schedule(() -> {
            if (!this.stopped) {
                super.reconnect();
            }
        }, delaySeconds, TimeUnit.SECONDS);
    }

    public void reconnectNow() {
        this.scheduleReconnect(0L);
    }

    public void stopWithoutReconnect(int code, String reason) {
        this.stopped = true;
        this.scheduler.shutdownNow();
        this.close(code, reason);
    }
}

