/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao;

import com.github.theword.queqiao.event.forge.ForgeAdvancementEvent;
import com.github.theword.queqiao.event.forge.ForgeCommandEvent;
import com.github.theword.queqiao.event.forge.ForgePlayerDeathEvent;
import com.github.theword.queqiao.event.forge.ForgePlayerLoggedInEvent;
import com.github.theword.queqiao.event.forge.ForgePlayerLoggedOutEvent;
import com.github.theword.queqiao.event.forge.ForgeServerChatEvent;
import com.github.theword.queqiao.event.forge.ForgeServerPlayer;
import com.github.theword.queqiao.event.forge.dto.advancement.ForgeAdvancement;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.ForgeTool;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class EventProcessor {
    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        if (event.isCanceled() || !Tool.config.getSubscribeEvent().isPlayerChat()) {
            return;
        }
        ForgeServerPlayer player = ForgeTool.getForgePlayer(event.getPlayer());
        ForgeServerChatEvent forgeServerChatEvent = new ForgeServerChatEvent("", player, event.getMessage());
        Tool.sendWebsocketMessage(forgeServerChatEvent);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.isCanceled() || !Tool.config.getSubscribeEvent().isPlayerJoin()) {
            return;
        }
        ForgeServerPlayer player = ForgeTool.getForgePlayer((EntityPlayerMP)event.player);
        ForgePlayerLoggedInEvent forgePlayerLoggedInEvent = new ForgePlayerLoggedInEvent(player);
        Tool.sendWebsocketMessage(forgePlayerLoggedInEvent);
    }

    @SubscribeEvent
    public void onPlayerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.isCanceled() || !Tool.config.getSubscribeEvent().isPlayerQuit()) {
            return;
        }
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)event.player;
        ForgeServerPlayer player = ForgeTool.getForgePlayer(entityPlayerMP);
        ForgePlayerLoggedOutEvent forgePlayerLoggedOutEvent = new ForgePlayerLoggedOutEvent(player);
        Tool.sendWebsocketMessage(forgePlayerLoggedOutEvent);
    }

    @SubscribeEvent
    public void onPlayerCommand(CommandEvent event) {
        if (event.isCanceled() || !Tool.config.getSubscribeEvent().isPlayerCommand()) {
            return;
        }
        if (!(event.getSender() instanceof EntityPlayerMP)) {
            return;
        }
        StringBuilder commandString = new StringBuilder(event.getCommand().func_71517_b());
        for (String parameter : event.getParameters()) {
            commandString.append(" ").append(parameter);
        }
        String command = Tool.isRegisterOrLoginCommand(commandString.toString());
        if (command.isEmpty()) {
            return;
        }
        ForgeServerPlayer player = ForgeTool.getForgePlayer((EntityPlayerMP)event.getSender());
        ForgeCommandEvent forgeCommandEvent = new ForgeCommandEvent("", player, command);
        Tool.sendWebsocketMessage(forgeCommandEvent);
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.isCanceled() || !Tool.config.getSubscribeEvent().isPlayerDeath()) {
            return;
        }
        if (event.getEntity() == null || !(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        ForgeServerPlayer player = ForgeTool.getForgePlayer((EntityPlayerMP)event.getEntity());
        String message = event.getEntityLiving().func_110142_aN().func_151521_b().func_150260_c();
        ForgePlayerDeathEvent forgePlayerDeathEvent = new ForgePlayerDeathEvent("", player, message);
        Tool.sendWebsocketMessage(forgePlayerDeathEvent);
    }

    @SubscribeEvent
    public void onPlayerAdvancement(AdvancementEvent event) {
        if (!Tool.config.getSubscribeEvent().isPlayerAdvancement()) {
            return;
        }
        Advancement advancement = event.getAdvancement();
        ForgeServerPlayer player = ForgeTool.getForgePlayer((EntityPlayerMP)event.getEntityPlayer());
        ForgeAdvancement forgeAdvancement = ForgeTool.getForgeAdvancement(advancement);
        ForgeAdvancementEvent forgeAdvancementEvent = new ForgeAdvancementEvent(player, forgeAdvancement);
        Tool.sendWebsocketMessage(forgeAdvancementEvent);
    }
}

