/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.tool.config;

import com.github.theword.queqiao.tool.config.CommonConfig;
import com.github.theword.queqiao.tool.config.SubscribeEventConfig;
import com.github.theword.queqiao.tool.config.WebSocketClientConfig;
import com.github.theword.queqiao.tool.config.WebSocketServerConfig;
import com.github.theword.queqiao.tool.utils.Tool;
import java.util.List;
import java.util.Map;

public class Config
extends CommonConfig {
    private boolean enable = true;
    private boolean debug = false;
    private String serverName = "Server";
    private String accessToken = "";
    private String messagePrefix = "[\u9e4a\u6865]";
    private WebSocketServerConfig websocketServer = new WebSocketServerConfig();
    private WebSocketClientConfig websocketClient = new WebSocketClientConfig();
    private SubscribeEventConfig subscribeEvent = new SubscribeEventConfig();

    public Config(boolean isModServer) {
        String configFolder = isModServer ? "config" : "plugins";
        String serverType = isModServer ? "\u6a21\u7ec4" : "\u63d2\u4ef6";
        Tool.logger.info("\u5f53\u524d\u670d\u52a1\u7aef\u7c7b\u578b\u4e3a\uff1a{}\u670d", (Object)serverType);
        this.readConfigFile(configFolder, "config.yml");
    }

    public static Config loadConfig(boolean isModServer) {
        return new Config(isModServer);
    }

    @Override
    protected void loadConfigValues(Map<String, Object> configMap) {
        this.enable = (Boolean)configMap.get("enable");
        this.debug = (Boolean)configMap.get("debug");
        this.serverName = (String)configMap.get("server_name");
        this.accessToken = (String)configMap.get("access_token");
        this.messagePrefix = (String)configMap.get("message_prefix");
        this.loadWebsocketServerConfig(configMap);
        this.loadWebsocketClientConfig(configMap);
        this.loadSubscribeEventConfig(configMap);
        Tool.config = this;
    }

    private void loadWebsocketServerConfig(Map<String, Object> configMap) {
        Map websocketServerConfig = (Map)configMap.get("websocket_server");
        this.websocketServer.setEnable((Boolean)websocketServerConfig.get("enable"));
        this.websocketServer.setHost((String)websocketServerConfig.get("host"));
        this.websocketServer.setPort((Integer)websocketServerConfig.get("port"));
    }

    private void loadWebsocketClientConfig(Map<String, Object> configMap) {
        Map websocketClientConfig = (Map)configMap.get("websocket_client");
        this.websocketClient.setEnable((Boolean)websocketClientConfig.get("enable"));
        this.websocketClient.setReconnectInterval((Integer)websocketClientConfig.get("reconnect_interval"));
        this.websocketClient.setReconnectMaxTimes((Integer)websocketClientConfig.get("reconnect_max_times"));
        this.websocketClient.setUrlList((List)websocketClientConfig.get("url_list"));
    }

    private void loadSubscribeEventConfig(Map<String, Object> configMap) {
        Map subscribeEventConfig = (Map)configMap.get("subscribe_event");
        this.subscribeEvent.setPlayerChat((Boolean)subscribeEventConfig.get("player_chat"));
        this.subscribeEvent.setPlayerCommand((Boolean)subscribeEventConfig.get("player_command"));
        this.subscribeEvent.setPlayerDeath((Boolean)subscribeEventConfig.get("player_death"));
        this.subscribeEvent.setPlayerJoin((Boolean)subscribeEventConfig.get("player_join"));
        this.subscribeEvent.setPlayerQuit((Boolean)subscribeEventConfig.get("player_quit"));
        this.subscribeEvent.setPlayerAdvancement((Boolean)subscribeEventConfig.get("player_advancement"));
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    public WebSocketServerConfig getWebsocketServer() {
        return this.websocketServer;
    }

    public WebSocketClientConfig getWebsocketClient() {
        return this.websocketClient;
    }

    public SubscribeEventConfig getSubscribeEvent() {
        return this.subscribeEvent;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setMessagePrefix(String messagePrefix) {
        this.messagePrefix = messagePrefix;
    }

    public void setWebsocketServer(WebSocketServerConfig websocketServer) {
        this.websocketServer = websocketServer;
    }

    public void setWebsocketClient(WebSocketClientConfig websocketClient) {
        this.websocketClient = websocketClient;
    }

    public void setSubscribeEvent(SubscribeEventConfig subscribeEvent) {
        this.subscribeEvent = subscribeEvent;
    }

    public String toString() {
        return "Config(enable=" + this.isEnable() + ", debug=" + this.isDebug() + ", serverName=" + this.getServerName() + ", accessToken=" + this.getAccessToken() + ", messagePrefix=" + this.getMessagePrefix() + ", websocketServer=" + this.getWebsocketServer() + ", websocketClient=" + this.getWebsocketClient() + ", subscribeEvent=" + this.getSubscribeEvent() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        String this$serverName = this.getServerName();
        String other$serverName = other.getServerName();
        if (this$serverName == null ? other$serverName != null : !this$serverName.equals(other$serverName)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$messagePrefix = this.getMessagePrefix();
        String other$messagePrefix = other.getMessagePrefix();
        if (this$messagePrefix == null ? other$messagePrefix != null : !this$messagePrefix.equals(other$messagePrefix)) {
            return false;
        }
        WebSocketServerConfig this$websocketServer = this.getWebsocketServer();
        WebSocketServerConfig other$websocketServer = other.getWebsocketServer();
        if (this$websocketServer == null ? other$websocketServer != null : !((Object)this$websocketServer).equals(other$websocketServer)) {
            return false;
        }
        WebSocketClientConfig this$websocketClient = this.getWebsocketClient();
        WebSocketClientConfig other$websocketClient = other.getWebsocketClient();
        if (this$websocketClient == null ? other$websocketClient != null : !((Object)this$websocketClient).equals(other$websocketClient)) {
            return false;
        }
        SubscribeEventConfig this$subscribeEvent = this.getSubscribeEvent();
        SubscribeEventConfig other$subscribeEvent = other.getSubscribeEvent();
        return !(this$subscribeEvent == null ? other$subscribeEvent != null : !((Object)this$subscribeEvent).equals(other$subscribeEvent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        String $serverName = this.getServerName();
        result = result * 59 + ($serverName == null ? 43 : $serverName.hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $messagePrefix = this.getMessagePrefix();
        result = result * 59 + ($messagePrefix == null ? 43 : $messagePrefix.hashCode());
        WebSocketServerConfig $websocketServer = this.getWebsocketServer();
        result = result * 59 + ($websocketServer == null ? 43 : ((Object)$websocketServer).hashCode());
        WebSocketClientConfig $websocketClient = this.getWebsocketClient();
        result = result * 59 + ($websocketClient == null ? 43 : ((Object)$websocketClient).hashCode());
        SubscribeEventConfig $subscribeEvent = this.getSubscribeEvent();
        result = result * 59 + ($subscribeEvent == null ? 43 : ((Object)$subscribeEvent).hashCode());
        return result;
    }
}

