/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.tool.deserializer;

import com.github.theword.queqiao.tool.payload.MessagePayload;
import com.github.theword.queqiao.tool.payload.PrivateMessagePayload;
import com.github.theword.queqiao.tool.utils.PayloadUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.UUID;

public class MessagePayloadDeserializer
implements JsonDeserializer<MessagePayload> {
    public MessagePayload deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject.has("uuid") || jsonObject.has("nickname")) {
            PrivateMessagePayload privatePayload = new PrivateMessagePayload();
            privatePayload.setUuid((UUID)context.deserialize(jsonObject.get("uuid"), UUID.class));
            privatePayload.setNickname((String)context.deserialize(jsonObject.get("nickname"), String.class));
            privatePayload.setMessage(PayloadUtils.deserializeMessageSegmentList(jsonObject.get("message"), context));
            return privatePayload;
        }
        MessagePayload payload = new MessagePayload();
        JsonElement messageElement = jsonObject.get("message");
        payload.setMessage(PayloadUtils.deserializeMessageSegmentList(messageElement, context));
        return payload;
    }
}

