/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.tool.utils;

import com.github.theword.queqiao.tool.handle.ParseJsonToEventService;
import com.github.theword.queqiao.tool.payload.BasePayload;
import com.github.theword.queqiao.tool.payload.MessagePayload;
import com.github.theword.queqiao.tool.payload.PrivateMessagePayload;
import com.github.theword.queqiao.tool.payload.TitlePayload;
import com.github.theword.queqiao.tool.response.Response;
import com.github.theword.queqiao.tool.response.ResponseEnum;
import com.github.theword.queqiao.tool.utils.GsonUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;

public class TestUtils {
    public static Response testParseJsonMessage(String message, ParseJsonToEventService parseJsonToEventImpl) {
        Gson gson = GsonUtils.buildGson();
        BasePayload basePayload = (BasePayload)gson.fromJson(message, BasePayload.class);
        JsonElement data = basePayload.getData();
        Response response = new Response(200, ResponseEnum.SUCCESS, "success", "No data", basePayload.getEcho());
        try {
            switch (basePayload.getApi()) {
                case "broadcast": 
                case "send_msg": 
                case "send_actionbar": {
                    MessagePayload messageList = (MessagePayload)gson.fromJson(data, MessagePayload.class);
                    parseJsonToEventImpl.parseMessageListToComponent(messageList.getMessage());
                    break;
                }
                case "send_title": {
                    TitlePayload titlePayload = (TitlePayload)gson.fromJson(data, TitlePayload.class);
                    parseJsonToEventImpl.parseMessageListToComponent(titlePayload.getTitle());
                    if (titlePayload.getSubtitle() != null) {
                        parseJsonToEventImpl.parseMessageListToComponent(titlePayload.getSubtitle());
                    }
                    break;
                }
                case "send_private_msg": {
                    PrivateMessagePayload privateMessagePayload = (PrivateMessagePayload)gson.fromJson(data, PrivateMessagePayload.class);
                    parseJsonToEventImpl.parseMessageListToComponent(privateMessagePayload.getMessage());
                    break;
                }
                case "send_command": {
                    break;
                }
                default: {
                    response.setStatus(ResponseEnum.FAILED);
                    response.setMessage("\u672a\u77e5\u7684API\uff1a" + basePayload.getApi());
                    break;
                }
            }
        }
        catch (Exception e) {
            response.setStatus(ResponseEnum.FAILED);
            response.setMessage("\u5728\u5904\u7406\u6d88\u606f\u65f6\u51fa\u73b0\u5f02\u5e38");
            response.setData(e.getMessage());
        }
        return response;
    }
}

