/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.tool.utils;

import com.github.theword.queqiao.tool.config.Config;
import com.github.theword.queqiao.tool.event.base.BaseEvent;
import com.github.theword.queqiao.tool.handle.HandleApiService;
import com.github.theword.queqiao.tool.handle.HandleCommandReturnMessageService;
import com.github.theword.queqiao.tool.payload.modle.component.CommonTextComponent;
import com.github.theword.queqiao.tool.utils.WebsocketManager;
import shadow.org.slf4j.Logger;
import shadow.org.slf4j.LoggerFactory;

public class Tool {
    public static Logger logger = null;
    public static Config config = null;
    public static String SERVER_VERSION = "Unknown";
    public static String SERVER_TYPE = "Unknown";
    public static WebsocketManager websocketManager = null;
    public static HandleApiService handleApiService = null;
    public static HandleCommandReturnMessageService handleCommandReturnMessageService = null;

    public static void initTool(boolean isModServer, String serverVersion, String serverType, HandleApiService handleApiImpl, HandleCommandReturnMessageService handleCommandReturnMessageImpl) {
        logger = LoggerFactory.getLogger("QueQiao");
        logger.info("\u6b63\u5728\u542f\u52a8");
        config = Config.loadConfig(isModServer);
        SERVER_VERSION = serverVersion;
        SERVER_TYPE = serverType;
        websocketManager = new WebsocketManager();
        handleApiService = handleApiImpl;
        handleCommandReturnMessageService = handleCommandReturnMessageImpl;
        logger.info("\u521d\u59cb\u5316\u5b8c\u6210");
    }

    public static void sendWebsocketMessage(BaseEvent event) {
        if (config.isEnable()) {
            websocketManager.getWsClientList().forEach(wsClient -> wsClient.send(event.getJson()));
            if (websocketManager.getWsServer() != null) {
                websocketManager.getWsServer().broadcast(event.getJson());
            }
        }
    }

    public static String isRegisterOrLoginCommand(String command) {
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        if (command.startsWith("l ") || command.startsWith("login ") || command.startsWith("register ") || command.startsWith("reg ") || command.startsWith("queqiao ")) {
            return "";
        }
        return command;
    }

    public static void commandReturn(Object commandReturner, String message) {
        if (commandReturner != null) {
            handleCommandReturnMessageService.handleCommandReturnMessage(commandReturner, message);
        }
    }

    public static void debugLog(String message) {
        if (config.isDebug()) {
            logger.info(message);
        }
    }

    public static void debugLog(String format, Object ... args) {
        if (config.isDebug()) {
            logger.info(format, args);
        }
    }

    public static CommonTextComponent getPrefixComponent() {
        CommonTextComponent CommonTextComponent2 = new CommonTextComponent(config.getMessagePrefix());
        CommonTextComponent2.setColor("yellow");
        return CommonTextComponent2;
    }
}

