/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.tool.utils;

import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.tool.websocket.WsClient;
import com.github.theword.queqiao.tool.websocket.WsServer;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class WebsocketManager {
    private final List<WsClient> wsClientList = new ArrayList<WsClient>();
    private WsServer wsServer;

    private void startWebsocketClients(Object commandReturner) {
        if (Tool.config.getWebsocketClient().isEnable()) {
            Tool.commandReturn(commandReturner, "WebSocket Client \u6b63\u5728\u542f\u52a8...");
            Tool.config.getWebsocketClient().getUrlList().forEach(websocketUrl -> {
                try {
                    WsClient wsClient = new WsClient(new URI((String)websocketUrl));
                    wsClient.connect();
                    this.wsClientList.add(wsClient);
                }
                catch (URISyntaxException e) {
                    Tool.commandReturn(commandReturner, String.format("\u8fde\u63a5\u81f3\uff1a%s \u7684 WebSocket URL \u683c\u5f0f\u9519\u8bef\uff0c\u65e0\u6cd5\u8fde\u63a5\uff01", websocketUrl));
                }
            });
        }
    }

    private void stopWebsocketClients(int code, String reason, Object commandReturner) {
        this.wsClientList.forEach(wsClient -> {
            Tool.commandReturn(commandReturner, String.format(reason, wsClient.getURI()));
            wsClient.stopWithoutReconnect(code, String.format(reason, wsClient.getURI()));
        });
        this.wsClientList.clear();
        Tool.commandReturn(commandReturner, "\u5df2\u6e05\u7a7a Websocket Client \u5217\u8868\u3002");
    }

    public void restartWebsocketClients(Object commandReturner) {
        Tool.commandReturn(commandReturner, "Websocket Client \u6b63\u5728\u91cd\u8f7d");
        this.stopWebsocketClients(1000, "Websocket \u6b63\u5728\u91cd\u8f7d", commandReturner);
        this.startWebsocketClients(commandReturner);
        Tool.commandReturn(commandReturner, "Websocket Client \u91cd\u8f7d\u5b8c\u6bd5");
    }

    private void startWebsocketServer(Object commandReturner) {
        if (Tool.config.getWebsocketServer().isEnable()) {
            this.wsServer = new WsServer(new InetSocketAddress(Tool.config.getWebsocketServer().getHost(), Tool.config.getWebsocketServer().getPort()));
            this.wsServer.start();
            Tool.commandReturn(commandReturner, String.format("WebSocket Server \u5728 %s:%s \u542f\u52a8...", Tool.config.getWebsocketServer().getHost(), Tool.config.getWebsocketServer().getPort()));
        }
    }

    private void stopWebsocketServer(Object commandReturner, String reason) {
        if (this.wsServer != null) {
            try {
                this.wsServer.stop(0, reason);
                Tool.commandReturn(commandReturner, reason);
            }
            catch (InterruptedException e) {
                Tool.commandReturn(commandReturner, "Websocket Server \u6b63\u5728\u542f\u52a8\u65f6\u51fa\u73b0\u5f02\u5e38\u3002");
                Tool.debugLog(e.getMessage());
            }
            this.wsServer = null;
        }
    }

    public void restartWebsocketServer(Object commandReturner) {
        this.stopWebsocketServer(commandReturner, "Websocket Server \u6b63\u5728\u91cd\u8f7d");
        this.startWebsocketServer(commandReturner);
        Tool.commandReturn(commandReturner, "Websocket Server \u91cd\u8f7d\u5b8c\u6bd5");
    }

    public void startWebsocket(Object commandReturner) {
        this.startWebsocketClients(commandReturner);
        this.startWebsocketServer(commandReturner);
    }

    public void startWebsocketOnServerStart() {
        this.startWebsocket(null);
    }

    public void stopWebsocketByServerClose() {
        this.stopWebsocket(1000, "\u8fde\u63a5\u81f3\uff1a%s \u7684 WebSocket Client \u6b63\u5728\u5173\u95ed\u3002", null);
    }

    public void stopWebsocket(int code, String reason, Object commandReturner) {
        this.stopWebsocketClients(code, reason, commandReturner);
        this.stopWebsocketServer(commandReturner, reason);
    }

    public List<WsClient> getWsClientList() {
        return this.wsClientList;
    }

    public WsServer getWsServer() {
        return this.wsServer;
    }
}

