/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.tool.websocket;

import com.github.theword.queqiao.tool.handle.HandleProtocolMessage;
import com.github.theword.queqiao.tool.response.Response;
import com.github.theword.queqiao.tool.utils.Tool;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class WsServer
extends WebSocketServer {
    private final String hostName;
    private final int port;
    private final HandleProtocolMessage handleProtocolMessage = new HandleProtocolMessage();

    public WsServer(InetSocketAddress address) {
        super(address);
        super.setReuseAddr(true);
        this.hostName = address.getHostName();
        this.port = address.getPort();
    }

    private String getClientAddress(WebSocket webSocket) {
        return webSocket.getRemoteSocketAddress().toString().replaceFirst("/", "");
    }

    @Override
    public void onOpen(WebSocket webSocket, ClientHandshake clientHandshake) {
        String originServerName = clientHandshake.getFieldValue("x-self-name");
        if (originServerName.isEmpty()) {
            Tool.logger.warn(String.format("\u6765\u81ea\uff1a%s \u7684 \u8fde\u63a5\u8bf7\u6c42\u5934\u4e2d\u7f3a\u5c11\u670d\u52a1\u5668\u540d\uff0c\u5c06\u65ad\u5f00\u8fde\u63a5", this.getClientAddress(webSocket)));
            webSocket.close(1008, "Missing X-Self-name Header");
            return;
        }
        String clientOrigin = clientHandshake.getFieldValue("x-client-origin");
        if (clientOrigin.equalsIgnoreCase("minecraft")) {
            Tool.logger.warn(String.format("\u6765\u81ea\uff1a%s \u7684 \u8fde\u63a5\u8bf7\u6c42\u5934\u4e2d\u5ba2\u6237\u7aef\u6765\u6e90\u9519\u8bef\uff0c\u5c06\u65ad\u5f00\u8fde\u63a5", this.getClientAddress(webSocket)));
            webSocket.close(1008, "X-Client-Origin Header cannot be minecraft");
            return;
        }
        String serverName = URLDecoder.decode(originServerName, StandardCharsets.UTF_8.toString());
        if (serverName.isEmpty()) {
            Tool.logger.warn(String.format("\u6765\u81ea\uff1a%s \u7684 \u8fde\u63a5\u8bf7\u6c42\u5934\u4e2d\u670d\u52a1\u5668\u540d\u89e3\u6790\u5931\u8d25\uff0c\u5c06\u65ad\u5f00\u8fde\u63a5", this.getClientAddress(webSocket)));
            webSocket.close(1008, "X-Self-name Header cannot be empty");
            return;
        }
        if (!serverName.equals(Tool.config.getServerName())) {
            Tool.logger.warn(String.format("\u6765\u81ea\uff1a%s \u7684 \u8fde\u63a5\u8bf7\u6c42\u5934\u4e2d\u670d\u52a1\u5668\u540d\uff1a%s \u9519\u8bef\uff0c\u5c06\u65ad\u5f00\u8fde\u63a5", this.getClientAddress(webSocket), serverName));
            webSocket.close(1008, "X-Self-name Header is wrong");
            return;
        }
        String accessToken = clientHandshake.getFieldValue("Authorization");
        if (!Tool.config.getAccessToken().isEmpty() && !accessToken.equals("Bearer " + Tool.config.getAccessToken())) {
            Tool.logger.warn(String.format("\u6765\u81ea\uff1a%s \u7684 \u8fde\u63a5\u8eab\u4efd\u9a8c\u8bc1\u7801\uff1a%s \u5931\u8d25\uff0c\u5c06\u65ad\u5f00\u8fde\u63a5", this.getClientAddress(webSocket), accessToken));
            webSocket.close(1008, "Authorization Header is wrong");
            return;
        }
        Tool.logger.info(String.format("\u6765\u81ea\uff1a%s \u7684 \u5ba2\u6237\u7aef\u5df2\u8fde\u63a5", this.getClientAddress(webSocket)));
    }

    @Override
    public void onClose(WebSocket webSocket, int code, String reason, boolean remote) {
        String closeReason = remote ? "\u6765\u81ea\uff1a%s \u7684 \u5ba2\u6237\u7aef\u5df2\u65ad\u5f00" : "\u6765\u81ea\uff1a%s \u7684 \u5ba2\u6237\u7aef\u5df2\u88ab\u65ad\u5f00";
        Tool.logger.info(String.format(closeReason, this.getClientAddress(webSocket)));
    }

    @Override
    public void onMessage(WebSocket webSocket, String message) {
        if (Tool.config.isEnable()) {
            Response response = this.handleProtocolMessage.handleWebSocketJson(webSocket, message);
            webSocket.send(response.getJson());
        }
    }

    @Override
    public void onError(WebSocket webSocket, Exception exception) {
        Tool.logger.warn(String.format("\u6765\u81ea\uff1a%s \u7684 WebSocket \u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\uff1a%s", this.getClientAddress(webSocket), exception.getMessage()));
    }

    @Override
    public void onStart() {
        Tool.logger.info(String.format("WebSocket Server \u5728 %s:%s \u542f\u52a8...", this.hostName, this.port));
    }

    @Override
    public void broadcast(String text) {
        super.broadcast(text);
        Tool.debugLog(String.format("\u5411\u6240\u6709\u5ba2\u6237\u7aef\u5e7f\u64ad\u6d88\u606f\uff1a%s", text));
    }
}

