/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.utils;

import com.github.theword.queqiao.tool.handle.ParseJsonToEventService;
import com.github.theword.queqiao.tool.payload.MessageSegment;
import com.github.theword.queqiao.tool.payload.modle.component.CommonBaseComponent;
import com.github.theword.queqiao.tool.payload.modle.component.CommonTextComponent;
import com.github.theword.queqiao.tool.payload.modle.hover.CommonHoverEntity;
import com.github.theword.queqiao.tool.payload.modle.hover.CommonHoverItem;
import com.github.theword.queqiao.tool.utils.Tool;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class ParseJsonToEventImpl
implements ParseJsonToEventService {
    public TextComponentString parseMessageListToComponent(List<MessageSegment> myBaseComponentList) {
        TextComponentString mutableComponent = new TextComponentString("");
        StringBuilder msgLogText = new StringBuilder();
        for (MessageSegment messageSegment : myBaseComponentList) {
            TextComponentString tempMutableComponent = this.parsePerMessageToComponent(messageSegment.getData());
            mutableComponent.func_150257_a((ITextComponent)tempMutableComponent);
            msgLogText.append(messageSegment.getData().getText());
        }
        Tool.logger.info(msgLogText.toString());
        return mutableComponent;
    }

    public TextComponentString parseCommonBaseComponentListToComponent(List<CommonBaseComponent> myBaseComponentList) {
        TextComponentString mutableComponent = new TextComponentString("");
        for (CommonBaseComponent commonBaseComponent : myBaseComponentList) {
            TextComponentString tempMutableComponent = this.parsePerMessageToComponent(commonBaseComponent);
            mutableComponent.func_150257_a((ITextComponent)tempMutableComponent);
        }
        return mutableComponent;
    }

    public TextComponentString parsePerMessageToComponent(CommonBaseComponent myBaseComponent) {
        TextComponentString tempMutableComponent = new TextComponentString(myBaseComponent.getText());
        Style style = this.getStyleFromBaseComponent(myBaseComponent);
        if (myBaseComponent instanceof CommonTextComponent) {
            HoverEvent hoverEventFromBaseComponent;
            ClickEvent clickEventFromBaseComponent;
            CommonTextComponent commonTextComponent = (CommonTextComponent)myBaseComponent;
            if (commonTextComponent.getClickEvent() != null && (clickEventFromBaseComponent = this.getClickEventFromBaseComponent(commonTextComponent)) != null) {
                style = style.func_150241_a(clickEventFromBaseComponent);
            }
            if (commonTextComponent.getHoverEvent() != null && (hoverEventFromBaseComponent = this.getHoverEventFromBaseComponent(commonTextComponent)) != null) {
                style = style.func_150209_a(hoverEventFromBaseComponent);
            }
        }
        tempMutableComponent.func_150255_a(style);
        return tempMutableComponent;
    }

    private Style getStyleFromBaseComponent(CommonBaseComponent myBaseComponent) {
        ResourceLocation font = null;
        if (myBaseComponent.getFont() != null) {
            font = new ResourceLocation(myBaseComponent.getFont());
        }
        Style style = new Style().func_150227_a(Boolean.valueOf(myBaseComponent.isBold())).func_150217_b(Boolean.valueOf(myBaseComponent.isItalic())).func_179989_a(myBaseComponent.getInsertion()).func_150228_d(Boolean.valueOf(myBaseComponent.isUnderlined())).func_150225_c(Boolean.valueOf(myBaseComponent.isStrikethrough())).func_150237_e(Boolean.valueOf(myBaseComponent.isObfuscated()));
        if (myBaseComponent.getColor() != null && !myBaseComponent.getColor().isEmpty()) {
            style.func_150238_a(TextFormatting.valueOf((String)myBaseComponent.getColor().toUpperCase()));
        } else {
            style.func_150238_a(TextFormatting.WHITE);
        }
        return style;
    }

    private ClickEvent getClickEventFromBaseComponent(CommonTextComponent myTextComponent) {
        if (myTextComponent.getClickEvent() != null) {
            ClickEvent.Action tempAction = ClickEvent.Action.func_150672_a((String)myTextComponent.getClickEvent().getAction().toLowerCase());
            return new ClickEvent(tempAction, myTextComponent.getClickEvent().getValue());
        }
        return null;
    }

    public HoverEvent getHoverEventFromBaseComponent(CommonTextComponent myTextComponent) {
        HoverEvent hoverEvent = null;
        HoverEvent.Action action = HoverEvent.Action.func_150684_a((String)myTextComponent.getHoverEvent().getAction().toLowerCase());
        if (action.equals((Object)HoverEvent.Action.SHOW_TEXT)) {
            if (myTextComponent.getHoverEvent().getText() != null && !myTextComponent.getHoverEvent().getText().isEmpty()) {
                TextComponentString textComponent = this.parseCommonBaseComponentListToComponent(myTextComponent.getHoverEvent().getText());
                hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)textComponent);
            }
        } else if (action.equals((Object)HoverEvent.Action.SHOW_ITEM)) {
            CommonHoverItem commonHoverItem = myTextComponent.getHoverEvent().getItem();
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(commonHoverItem.getId()));
            ItemStack itemStack = new ItemStack(item, commonHoverItem.getCount().intValue());
            hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_ITEM, (ITextComponent)new TextComponentString(itemStack.func_82833_r()));
        } else if (action.equals((Object)HoverEvent.Action.SHOW_ENTITY)) {
            CommonHoverEntity commonHoverEntity = myTextComponent.getHoverEvent().getEntity();
            hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_ENTITY, (ITextComponent)this.parseCommonBaseComponentListToComponent(commonHoverEntity.getName()));
        }
        return hoverEvent;
    }
}

