/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.tool;

import com.github.theword.queqiao.tool.config.Config;
import com.github.theword.queqiao.tool.event.base.BaseEvent;
import com.github.theword.queqiao.tool.handle.HandleApiService;
import com.github.theword.queqiao.tool.handle.HandleCommandReturnMessageService;
import com.github.theword.queqiao.tool.rcon.RconClient;
import com.github.theword.queqiao.tool.utils.GsonUtils;
import com.github.theword.queqiao.tool.utils.WebsocketManager;
import com.google.gson.Gson;
import java.io.IOException;
import shadow.org.slf4j.Logger;
import shadow.org.slf4j.LoggerFactory;

public class GlobalContext {
    private static Config config;
    private static Logger logger;
    private static Gson gson;
    private static WebsocketManager websocketManager;
    private static HandleApiService handleApiService;
    private static HandleCommandReturnMessageService handleCommandReturnMessageService;
    private static String serverVersion;
    private static String serverType;
    private static RconClient rconClient;

    public static void init(boolean isModServer, String serverVersion, String serverType, HandleApiService handleApiImpl, HandleCommandReturnMessageService handleCommandReturnMessageImpl) {
        logger = LoggerFactory.getLogger("QueQiao");
        logger.info("\u6b63\u5728\u542f\u52a8");
        gson = GsonUtils.getGson();
        config = Config.loadConfig(isModServer, logger);
        GlobalContext.serverVersion = serverVersion;
        GlobalContext.serverType = serverType;
        handleApiService = handleApiImpl;
        handleCommandReturnMessageService = handleCommandReturnMessageImpl;
        logger.info("\u521d\u59cb\u5316\u5b8c\u6210");
        GlobalContext.initWebsocketManager();
        GlobalContext.initRconClient();
    }

    public static void executeReloadCommand(Object commandReturner, boolean isModServer) {
        GlobalContext.setConfig(Config.loadConfig(isModServer, logger));
        handleCommandReturnMessageService.sendReturnMessage(commandReturner, "\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5b8c\u6210");
        websocketManager.restart(commandReturner);
        GlobalContext.restartRconClient();
    }

    public static void shutdown() {
        websocketManager.stop(1000, "\u8fde\u63a5\u81f3\uff1a{} \u7684 WebSocket Client \u6b63\u5728\u5173\u95ed\uff0cCode {}\uff0cReason\uff1a{}\u3002", null);
        if (config.getRcon().isEnable() && rconClient != null) {
            rconClient.stop();
        }
        logger.info("\u9e4a\u6865\u5df2\u5173\u95ed");
    }

    private static void initWebsocketManager() {
        websocketManager = new WebsocketManager(logger, gson, handleCommandReturnMessageService);
        websocketManager.start(null);
    }

    public static void sendEvent(BaseEvent baseEvent) {
        websocketManager.sendEvent(baseEvent);
    }

    private static void initRconClient() {
        if (config.getRcon().isEnable()) {
            rconClient = new RconClient(logger, config.getRcon().getPort(), config.getRcon().getPassword());
            rconClient.connect();
        } else {
            logger.info("Rcon \u672a\u542f\u7528\uff0c\u8df3\u8fc7 Rcon \u5ba2\u6237\u7aef\u521d\u59cb\u5316");
        }
    }

    private static void restartRconClient() {
        if (rconClient == null) {
            GlobalContext.initRconClient();
        } else {
            rconClient.stop();
            rconClient.setPort(config.getRcon().getPort());
            rconClient.setPassword(config.getRcon().getPassword());
            rconClient.connect();
        }
    }

    public static String sendRconCommand(String command) throws IOException {
        if (!config.getRcon().isEnable()) {
            throw new IOException("Rcon \u672a\u542f\u7528\uff0c\u65e0\u6cd5\u53d1\u9001\u547d\u4ee4");
        }
        if (rconClient == null) {
            throw new IOException("Rcon \u672a\u542f\u7528\uff0c\u65e0\u6cd5\u53d1\u9001\u547d\u4ee4");
        }
        if (!rconClient.isConnected()) {
            throw new IOException("Rcon \u672a\u542f\u7528\uff0c\u65e0\u6cd5\u53d1\u9001\u547d\u4ee4");
        }
        return rconClient.sendCommand(command);
    }

    public static Config getConfig() {
        return config;
    }

    public static void setConfig(Config config) {
        GlobalContext.config = config;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        GlobalContext.logger = logger;
    }

    public static WebsocketManager getWebsocketManager() {
        return websocketManager;
    }

    public static HandleApiService getHandleApiService() {
        return handleApiService;
    }

    public static HandleCommandReturnMessageService getHandleCommandReturnMessageService() {
        return handleCommandReturnMessageService;
    }

    public static String getServerVersion() {
        return serverVersion;
    }

    public static String getServerType() {
        return serverType;
    }

    public static Gson getGson() {
        return gson;
    }
}

