/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao;

import com.github.theword.queqiao.tool.GlobalContext;
import com.github.theword.queqiao.tool.event.PlayerAchievementEvent;
import com.github.theword.queqiao.tool.event.PlayerChatEvent;
import com.github.theword.queqiao.tool.event.PlayerCommandEvent;
import com.github.theword.queqiao.tool.event.PlayerDeathEvent;
import com.github.theword.queqiao.tool.event.PlayerJoinEvent;
import com.github.theword.queqiao.tool.event.PlayerQuitEvent;
import com.github.theword.queqiao.tool.event.model.PlayerModel;
import com.github.theword.queqiao.tool.event.model.achievement.AchievementModel;
import com.github.theword.queqiao.tool.event.model.death.DeathModel;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.ForgeTool;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import net.minecraft.advancements.Advancement;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventProcessor {
    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerChat()) {
            return;
        }
        PlayerModel player = ForgeTool.getForgePlayer(event.getPlayer());
        String message = event.getMessage();
        String rawMessage = ITextComponent.Serializer.func_150696_a((ITextComponent)event.getComponent());
        PlayerChatEvent forgeServerChatEvent = new PlayerChatEvent(player, "", rawMessage, message);
        GlobalContext.sendEvent(forgeServerChatEvent);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerJoin()) {
            return;
        }
        PlayerModel player = ForgeTool.getForgePlayer((ServerPlayerEntity)event.getEntity());
        PlayerJoinEvent forgePlayerLoggedInEvent = new PlayerJoinEvent(player);
        GlobalContext.sendEvent(forgePlayerLoggedInEvent);
    }

    @SubscribeEvent
    public void onPlayerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerQuit()) {
            return;
        }
        PlayerModel player = ForgeTool.getForgePlayer((ServerPlayerEntity)event.getPlayer());
        PlayerQuitEvent forgePlayerLoggedOutEvent = new PlayerQuitEvent(player);
        GlobalContext.sendEvent(forgePlayerLoggedOutEvent);
    }

    @SubscribeEvent
    public void onPlayerCommand(CommandEvent event) {
        PlayerModel player;
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerCommand()) {
            return;
        }
        if (!(((CommandSource)event.getParseResults().getContext().getSource()).func_197022_f() instanceof ServerPlayerEntity)) {
            return;
        }
        String command = Tool.isRegisterOrLoginCommand(event.getParseResults().getReader().getString());
        String rawMessage = event.getParseResults().getContext().toString();
        if (command.isEmpty()) {
            return;
        }
        try {
            player = ForgeTool.getForgePlayer(((CommandSource)event.getParseResults().getContext().getSource()).func_197035_h());
        }
        catch (CommandSyntaxException e) {
            return;
        }
        PlayerCommandEvent forgeCommandEvent = new PlayerCommandEvent(player, "", rawMessage, command);
        GlobalContext.sendEvent(forgeCommandEvent);
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerDeath()) {
            return;
        }
        DeathModel deathModel = new DeathModel();
        if (!(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        PlayerModel player = ForgeTool.getForgePlayer((ServerPlayerEntity)event.getEntity());
        LivingEntity entity = (LivingEntity)event.getEntity();
        ITextComponent localizedDeathMessage = event.getSource().func_151519_b(entity);
        if (localizedDeathMessage instanceof TranslationTextComponent) {
            TranslationTextComponent translationTextComponent = (TranslationTextComponent)localizedDeathMessage;
            deathModel.setKey(translationTextComponent.func_150268_i());
            String[] args = (String[])Arrays.stream(translationTextComponent.func_150271_j()).map(arg -> {
                if (arg instanceof ITextComponent) {
                    return ((ITextComponent)arg).getString();
                }
                return String.valueOf(arg);
            }).toArray(String[]::new);
            deathModel.setArgs(args);
        }
        deathModel.setText(localizedDeathMessage.getString());
        PlayerDeathEvent forgeCommandEvent = new PlayerDeathEvent(player, deathModel);
        GlobalContext.sendEvent(forgeCommandEvent);
    }

    @SubscribeEvent
    public void onPlayerAdvancement(AdvancementEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerAdvancement()) {
            return;
        }
        Advancement advancement = event.getAdvancement();
        if (advancement.func_192068_c() == null || !advancement.func_192068_c().func_193220_i()) {
            return;
        }
        PlayerModel player = ForgeTool.getForgePlayer((ServerPlayerEntity)event.getPlayer());
        AchievementModel achievementModel = ForgeTool.getForgeAchievement(advancement);
        String advancementText = achievementModel.pattern(achievementModel.getDisplay().getFrame(), player.getNickname(), advancement.func_193123_j().getString());
        achievementModel.setText(advancementText);
        PlayerAchievementEvent forgeAdvancementEvent = new PlayerAchievementEvent(player, achievementModel);
        GlobalContext.sendEvent(forgeAdvancementEvent);
    }
}

