/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.handle;

import com.github.theword.queqiao.QueQiao;
import com.github.theword.queqiao.tool.handle.HandleApiService;
import com.github.theword.queqiao.tool.response.PrivateMessageResponse;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.ForgeTool;
import com.google.gson.JsonElement;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class HandleApiImpl
implements HandleApiService {
    @Override
    public void handleBroadcastMessage(JsonElement jsonElement) {
        IFormattableTextComponent mutableComponent = ITextComponent.Serializer.func_240641_a_((JsonElement)Tool.getPrefixComponent());
        assert (mutableComponent != null);
        IFormattableTextComponent messageComponent = ITextComponent.Serializer.func_240641_a_((JsonElement)jsonElement);
        if (messageComponent != null) {
            mutableComponent.func_230529_a_((ITextComponent)messageComponent);
        }
        this.sendPacket((IPacket<?>)new SChatPacket((ITextComponent)mutableComponent, ChatType.CHAT, UUID.randomUUID()));
    }

    @Override
    public void handleSendTitleMessage(JsonElement titleJsonElement, JsonElement subtitleJsonElement, int fadein, int stay, int fadeout) {
        IFormattableTextComponent subtitle;
        IFormattableTextComponent title;
        this.sendPacket((IPacket<?>)new STitlePacket(fadein, stay, fadeout));
        if (titleJsonElement != null && !titleJsonElement.isJsonNull() && (title = ITextComponent.Serializer.func_240641_a_((JsonElement)titleJsonElement)) != null) {
            this.sendPacket((IPacket<?>)new STitlePacket(STitlePacket.Type.TITLE, (ITextComponent)title));
        }
        if (subtitleJsonElement != null && !subtitleJsonElement.isJsonNull() && (subtitle = ITextComponent.Serializer.func_240641_a_((JsonElement)subtitleJsonElement)) != null) {
            this.sendPacket((IPacket<?>)new STitlePacket(STitlePacket.Type.SUBTITLE, (ITextComponent)subtitle));
        }
    }

    @Override
    public void handleSendActionBarMessage(JsonElement jsonElement) {
        IFormattableTextComponent actionBar = ITextComponent.Serializer.func_240641_a_((JsonElement)jsonElement);
        if (actionBar != null) {
            this.sendPacket((IPacket<?>)new SChatPacket((ITextComponent)actionBar, ChatType.GAME_INFO, UUID.randomUUID()));
        }
    }

    @Override
    public PrivateMessageResponse handleSendPrivateMessage(String nickname, UUID uuid, JsonElement jsonElement) {
        ServerPlayerEntity targetPlayer;
        if (uuid != null) {
            targetPlayer = QueQiao.minecraftServer.func_184103_al().func_177451_a(uuid);
        } else if (nickname != null && !nickname.isEmpty()) {
            targetPlayer = QueQiao.minecraftServer.func_184103_al().func_152612_a(nickname);
        } else {
            return PrivateMessageResponse.playerNotFound();
        }
        if (targetPlayer == null) {
            return PrivateMessageResponse.playerIsNull();
        }
        if (targetPlayer.func_193105_t()) {
            return PrivateMessageResponse.playerNotOnline();
        }
        IFormattableTextComponent mutableComponent = ITextComponent.Serializer.func_240641_a_((JsonElement)jsonElement);
        if (mutableComponent == null) {
            return PrivateMessageResponse.of(ForgeTool.getForgePlayer(targetPlayer), "\u6d88\u606f\u5185\u5bb9\u9519\u8bef");
        }
        targetPlayer.func_145747_a((ITextComponent)mutableComponent, UUID.randomUUID());
        return PrivateMessageResponse.sendSuccess(ForgeTool.getForgePlayer(targetPlayer));
    }

    private void sendPacket(IPacket<?> packet) {
        for (ServerPlayerEntity serverPlayer : QueQiao.minecraftServer.func_184103_al().func_181057_v()) {
            serverPlayer.field_71135_a.func_147359_a(packet);
        }
    }
}

