/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao;

import com.github.theword.queqiao.QueQiao;
import com.github.theword.queqiao.handle.HandleApiImpl;
import com.github.theword.queqiao.handle.HandleCommandReturnMessageImpl;
import com.github.theword.queqiao.tool.GlobalContext;
import com.github.theword.queqiao.tool.event.PlayerAchievementEvent;
import com.github.theword.queqiao.tool.event.PlayerChatEvent;
import com.github.theword.queqiao.tool.event.PlayerCommandEvent;
import com.github.theword.queqiao.tool.event.PlayerDeathEvent;
import com.github.theword.queqiao.tool.event.PlayerJoinEvent;
import com.github.theword.queqiao.tool.event.PlayerQuitEvent;
import com.github.theword.queqiao.tool.event.model.achievement.AchievementModel;
import com.github.theword.queqiao.tool.event.model.achievement.DisplayModel;
import com.github.theword.queqiao.tool.event.model.death.DeathModel;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.FoliaTool;
import io.papermc.paper.advancement.AdvancementDisplay;
import io.papermc.paper.event.player.AsyncChatEvent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import org.bukkit.advancement.Advancement;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerLoadEvent;

class EventProcessor
implements Listener {
    EventProcessor() {
    }

    @EventHandler
    public void onServerLoad(ServerLoadEvent event) {
        GlobalContext.init(false, QueQiao.instance.getServer().getVersion(), "spigot", new HandleApiImpl(), new HandleCommandReturnMessageImpl());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void onPlayerChat(AsyncChatEvent event) {
        if (event.isCancelled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerChat()) {
            return;
        }
        PlayerChatEvent playerChatEvent = new PlayerChatEvent(FoliaTool.getFoliaPlayer(event.getPlayer()), "", FoliaTool.getComponentJson(event.message()), FoliaTool.getComponentText(event.message()));
        GlobalContext.sendEvent(playerChatEvent);
    }

    @EventHandler
    void onPlayerDeath(org.bukkit.event.entity.PlayerDeathEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerDeath()) {
            return;
        }
        Component component = event.deathMessage();
        if (component == null) {
            return;
        }
        DeathModel deathModel = new DeathModel();
        if (component instanceof TranslatableComponent) {
            TranslatableComponent translatableComponent = (TranslatableComponent)component;
            deathModel.setKey(translatableComponent.key());
            String[] args = (String[])translatableComponent.arguments().stream().map(arg -> {
                if (arg instanceof TranslationArgument) {
                    TranslationArgument translationArgument = arg;
                    return translationArgument.toString();
                }
                return String.valueOf(arg);
            }).toArray(String[]::new);
            deathModel.setArgs(args);
        }
        deathModel.setText(FoliaTool.getComponentText(component));
        PlayerDeathEvent playerDeathEvent = new PlayerDeathEvent(FoliaTool.getFoliaPlayer(event.getEntity()), deathModel);
        GlobalContext.sendEvent(playerDeathEvent);
    }

    @EventHandler
    void onPlayerJoin(org.bukkit.event.player.PlayerJoinEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerJoin()) {
            return;
        }
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent(FoliaTool.getFoliaPlayer(event.getPlayer()));
        GlobalContext.sendEvent(playerJoinEvent);
    }

    @EventHandler
    void onPlayerQuit(org.bukkit.event.player.PlayerQuitEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerQuit()) {
            return;
        }
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent(FoliaTool.getFoliaPlayer(event.getPlayer()));
        GlobalContext.sendEvent(playerQuitEvent);
    }

    @EventHandler
    void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerCommand()) {
            return;
        }
        String command = Tool.isRegisterOrLoginCommand(event.getMessage());
        if (command.isEmpty()) {
            return;
        }
        PlayerCommandEvent playerCommandEvent = new PlayerCommandEvent(FoliaTool.getFoliaPlayer(event.getPlayer()), "", command, command);
        GlobalContext.sendEvent(playerCommandEvent);
    }

    @EventHandler
    void onPlayerAdvancement(PlayerAdvancementDoneEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerAdvancement()) {
            return;
        }
        Advancement advancement = event.getAdvancement();
        AdvancementDisplay advancementDisplay = advancement.getDisplay();
        if (advancementDisplay == null || !advancementDisplay.doesAnnounceToChat()) {
            return;
        }
        AchievementModel achievementModel = new AchievementModel();
        achievementModel.setKey(advancement.getKey().toString());
        achievementModel.setText(FoliaTool.getComponentText(event.message()));
        DisplayModel displayModel = new DisplayModel();
        displayModel.setTitle(((TranslatableComponent)advancementDisplay.title()).key());
        displayModel.setDescription(((TranslatableComponent)advancementDisplay.description()).key());
        displayModel.setFrame(advancementDisplay.frame().toString());
        achievementModel.setDisplay(displayModel);
        PlayerAchievementEvent foliaPlayerAdvancementDoneEvent = new PlayerAchievementEvent(FoliaTool.getFoliaPlayer(event.getPlayer()), achievementModel);
        GlobalContext.sendEvent(foliaPlayerAdvancementDoneEvent);
    }
}

