/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.utils;

import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.GlobalContext;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.event.base.BaseEvent;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.handle.HandleCommandReturnMessageService;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.websocket.WsClient;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.websocket.WsServer;
import com.github.theword.queqiao.shadow.org.slf4j.Logger;
import com.google.gson.Gson;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class WebsocketManager {
    private final List<WsClient> wsClientList;
    private WsServer wsServer;
    private final Logger logger;
    private final Gson gson;
    private final HandleCommandReturnMessageService handleCommandReturnMessageService;

    public List<WsClient> getWsClientList() {
        return this.wsClientList;
    }

    public WsServer getWsServer() {
        return this.wsServer;
    }

    public WebsocketManager(Logger logger, Gson gson, HandleCommandReturnMessageService handleCommandReturnMessageService) {
        this.logger = logger;
        this.gson = gson;
        this.handleCommandReturnMessageService = handleCommandReturnMessageService;
        this.wsClientList = new ArrayList<WsClient>();
    }

    private void startClients(Object commandReturner) {
        this.handleCommandReturnMessageService.sendReturnMessage(commandReturner, "WebSocket Client \u6b63\u5728\u542f\u52a8...");
        GlobalContext.getConfig().getWebsocketClient().getUrlList().forEach(websocketUrl -> {
            try {
                WsClient wsClient = new WsClient(new URI((String)websocketUrl), this.logger, this.gson, GlobalContext.getConfig().getServerName(), GlobalContext.getConfig().getAccessToken(), GlobalContext.getConfig().getWebsocketClient().getReconnectMaxTimes(), GlobalContext.getConfig().getWebsocketClient().getReconnectInterval(), GlobalContext.getConfig().isEnable());
                wsClient.connect();
                this.wsClientList.add(wsClient);
            }
            catch (URISyntaxException e) {
                this.handleCommandReturnMessageService.sendReturnMessage(commandReturner, String.format("\u8fde\u63a5\u81f3\uff1a{} \u7684 WebSocket URL \u683c\u5f0f\u9519\u8bef\uff0c\u65e0\u6cd5\u8fde\u63a5\uff01".replace("{}", "%s"), websocketUrl));
            }
        });
    }

    private void stopClients(int code, String reason, Object commandReturner) {
        for (WsClient wsClient : this.wsClientList) {
            this.handleCommandReturnMessageService.sendReturnMessage(commandReturner, String.format(reason, wsClient.getURI()));
            wsClient.stopWithoutReconnect(code, String.format(reason, wsClient.getURI()));
        }
        this.wsClientList.clear();
        this.handleCommandReturnMessageService.sendReturnMessage(commandReturner, "\u5df2\u6e05\u7a7a Websocket Client \u5217\u8868\u3002");
    }

    private void restartClients(Object commandReturner) {
        this.handleCommandReturnMessageService.sendReturnMessage(commandReturner, "Websocket Client \u6b63\u5728\u91cd\u8f7d");
        this.stopClients(1000, "Websocket \u6b63\u5728\u91cd\u8f7d", commandReturner);
        if (GlobalContext.getConfig().getWebsocketClient().isEnable()) {
            this.startClients(commandReturner);
        }
        this.handleCommandReturnMessageService.sendReturnMessage(commandReturner, "Websocket Client \u91cd\u8f7d\u5b8c\u6bd5");
    }

    private void startServer(Object commandReturner) {
        this.wsServer = new WsServer(new InetSocketAddress(GlobalContext.getConfig().getWebsocketServer().getHost(), GlobalContext.getConfig().getWebsocketServer().getPort()), this.logger, this.gson, GlobalContext.getConfig().getServerName(), GlobalContext.getConfig().getAccessToken(), GlobalContext.getConfig().isEnable());
        this.wsServer.start();
        this.handleCommandReturnMessageService.sendReturnMessage(commandReturner, String.format("WebSocket Server \u5728 {}:{} \u542f\u52a8...".replace("{}", "%s"), GlobalContext.getConfig().getWebsocketServer().getHost(), GlobalContext.getConfig().getWebsocketServer().getPort()));
    }

    private void stopServer(Object commandReturner, String reason) {
        if (this.wsServer != null) {
            try {
                this.wsServer.stop(0, reason);
                this.handleCommandReturnMessageService.sendReturnMessage(commandReturner, reason);
            }
            catch (InterruptedException e) {
                this.handleCommandReturnMessageService.sendReturnMessage(commandReturner, "Websocket Server \u6b63\u5728\u542f\u52a8\u65f6\u51fa\u73b0\u5f02\u5e38\u3002");
                Tool.debugLog(e.getMessage());
            }
            this.wsServer = null;
        }
    }

    private void restartServer(Object commandReturner) {
        this.stopServer(commandReturner, "Websocket Server \u6b63\u5728\u91cd\u8f7d");
        if (GlobalContext.getConfig().getWebsocketServer().isEnable()) {
            this.startServer(commandReturner);
        }
        this.handleCommandReturnMessageService.sendReturnMessage(commandReturner, "Websocket Server \u91cd\u8f7d\u5b8c\u6bd5");
    }

    public void start(Object commandReturner) {
        if (GlobalContext.getConfig().getWebsocketClient().isEnable()) {
            this.startClients(commandReturner);
        }
        if (GlobalContext.getConfig().getWebsocketServer().isEnable()) {
            this.startServer(commandReturner);
        }
    }

    public void stop(int code, String reason, Object commandReturner) {
        this.stopClients(code, reason, commandReturner);
        this.stopServer(commandReturner, reason);
    }

    public void restart(Object commandReturner) {
        this.restartClients(commandReturner);
        this.restartServer(commandReturner);
    }

    public void sendEvent(BaseEvent event) {
        if (GlobalContext.getConfig().isEnable()) {
            String json = this.gson.toJson((Object)event);
            this.wsClientList.forEach(wsClient -> {
                wsClient.send(json);
                Tool.debugLog("WebSocket Client {} \u53d1\u9001\u6d88\u606f: {}", wsClient.getURI(), json);
            });
            if (this.wsServer != null) {
                this.wsServer.broadcast(json);
                Tool.debugLog("WebSocket Server \u5e7f\u64ad\u6d88\u606f: {}", json);
            }
        }
    }
}

