/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.websocket;

import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.handle.HandleProtocolMessage;
import com.github.theword.queqiao.shadow.org.java_websocket.WebSocket;
import com.github.theword.queqiao.shadow.org.java_websocket.handshake.ClientHandshake;
import com.github.theword.queqiao.shadow.org.java_websocket.server.WebSocketServer;
import com.github.theword.queqiao.shadow.org.slf4j.Logger;
import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

public class WsServer
extends WebSocketServer {
    private final String hostName;
    private final int port;
    private final Logger logger;
    private final String serverName;
    private final String accessToken;
    private final boolean enabled;
    private final HandleProtocolMessage handleProtocolMessage;

    public WsServer(InetSocketAddress address, Logger logger, Gson gson, String serverName, String accessToken, boolean enabled) {
        super(address);
        super.setReuseAddr(true);
        this.logger = logger;
        this.hostName = address.getHostName();
        this.port = address.getPort();
        this.serverName = serverName;
        this.accessToken = accessToken;
        this.enabled = enabled;
        this.handleProtocolMessage = new HandleProtocolMessage(logger, gson);
    }

    private String getClientAddress(WebSocket webSocket) {
        return webSocket.getRemoteSocketAddress().toString().replaceFirst("/", "");
    }

    @Override
    public void onOpen(WebSocket webSocket, ClientHandshake clientHandshake) {
        String serverName;
        String originServerName = clientHandshake.getFieldValue("x-self-name");
        if (originServerName.isEmpty()) {
            this.logger.warn("\u6765\u81ea\uff1a{} \u7684 \u8fde\u63a5\u8bf7\u6c42\u5934\u4e2d\u7f3a\u5c11\u670d\u52a1\u5668\u540d\uff0c\u5c06\u65ad\u5f00\u8fde\u63a5", (Object)this.getClientAddress(webSocket));
            webSocket.close(1008, "Missing X-Self-name Header");
            return;
        }
        String clientOrigin = clientHandshake.getFieldValue("x-client-origin");
        if (clientOrigin.equalsIgnoreCase("minecraft")) {
            this.logger.warn("\u6765\u81ea\uff1a{} \u7684 \u8fde\u63a5\u8bf7\u6c42\u5934\u4e2d\u5ba2\u6237\u7aef\u6765\u6e90\u9519\u8bef\uff0c\u5c06\u65ad\u5f00\u8fde\u63a5", (Object)this.getClientAddress(webSocket));
            webSocket.close(1008, "X-Client-Origin Header cannot be minecraft");
            return;
        }
        try {
            serverName = URLDecoder.decode(originServerName, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("\u6765\u81ea\uff1a{} \u7684 \u8fde\u63a5\u8bf7\u6c42\u5934\u4e2d\u670d\u52a1\u5668\u540d\uff1a{} \u89e3\u7801\u5931\u8d25\uff0c\u5c06\u65ad\u5f00\u8fde\u63a5\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", this.getClientAddress(webSocket), originServerName, e.getMessage());
            webSocket.close(1008, "X-Self-name Header decode failed");
            return;
        }
        if (serverName.isEmpty()) {
            this.logger.warn("\u6765\u81ea\uff1a{} \u7684 \u8fde\u63a5\u8bf7\u6c42\u5934\u4e2d\u670d\u52a1\u5668\u540d\u89e3\u6790\u5931\u8d25\uff0c\u5c06\u65ad\u5f00\u8fde\u63a5", (Object)this.getClientAddress(webSocket));
            webSocket.close(1008, "X-Self-name Header cannot be empty");
            return;
        }
        if (!serverName.equals(this.serverName)) {
            this.logger.warn("\u6765\u81ea\uff1a{} \u7684 \u8fde\u63a5\u8bf7\u6c42\u5934\u4e2d\u670d\u52a1\u5668\u540d\uff1a{} \u9519\u8bef\uff0c\u5c06\u65ad\u5f00\u8fde\u63a5", (Object)this.getClientAddress(webSocket), (Object)serverName);
            webSocket.close(1008, "X-Self-name Header is wrong");
            return;
        }
        String accessToken = clientHandshake.getFieldValue("Authorization");
        if (!this.accessToken.isEmpty() && !accessToken.equals("Bearer " + this.accessToken)) {
            this.logger.warn("\u6765\u81ea\uff1a{} \u7684 \u8fde\u63a5\u8eab\u4efd\u9a8c\u8bc1\u7801\uff1a{} \u5931\u8d25\uff0c\u5c06\u65ad\u5f00\u8fde\u63a5", (Object)this.getClientAddress(webSocket), (Object)accessToken);
            webSocket.close(1008, "Authorization Header is wrong");
            return;
        }
        this.logger.info("\u6765\u81ea\uff1a{} \u7684 \u5ba2\u6237\u7aef\u5df2\u8fde\u63a5", (Object)this.getClientAddress(webSocket));
    }

    @Override
    public void onClose(WebSocket webSocket, int code, String reason, boolean remote) {
        String closeReason = remote ? "\u6765\u81ea\uff1a{} \u7684 \u5ba2\u6237\u7aef\u5df2\u65ad\u5f00" : "\u6765\u81ea\uff1a{} \u7684 \u5ba2\u6237\u7aef\u5df2\u88ab\u65ad\u5f00";
        this.logger.info(closeReason, (Object)this.getClientAddress(webSocket));
    }

    @Override
    public void onMessage(WebSocket webSocket, String message) {
        String response;
        if (this.enabled && (response = this.handleProtocolMessage.handleWebsocketJson(webSocket, message)) != null && !response.isEmpty()) {
            webSocket.send(response);
        }
    }

    @Override
    public void onError(WebSocket webSocket, Exception exception) {
        this.logger.warn("\u6765\u81ea\uff1a{} \u7684 WebSocket \u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)this.getClientAddress(webSocket), (Object)exception.getMessage());
    }

    @Override
    public void onStart() {
        this.logger.info("WebSocket Server \u5728 {}:{} \u542f\u52a8...", (Object)this.hostName, (Object)this.port);
    }

    @Override
    public void broadcast(String text) {
        super.broadcast(text);
    }
}

