/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao;

import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.GlobalContext;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.event.PlayerAchievementEvent;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.event.PlayerChatEvent;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.event.PlayerCommandEvent;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.event.PlayerDeathEvent;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.event.PlayerJoinEvent;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.event.PlayerQuitEvent;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.event.model.PlayerModel;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.event.model.achievement.AchievementModel;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.event.model.death.DeathModel;
import com.github.theword.queqiao.shadow.com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.ForgeTool;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.Arrays;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AchievementEvent;

public class EventProcessor {
    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerChat()) {
            return;
        }
        PlayerModel player = ForgeTool.getPlayerModel(event.player);
        String rawMessage = IChatComponent.Serializer.func_150696_a((IChatComponent)event.component);
        PlayerChatEvent forgeServerChatEvent = new PlayerChatEvent(player, "", rawMessage, event.message);
        GlobalContext.sendEvent(forgeServerChatEvent);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerJoin()) {
            return;
        }
        PlayerModel player = ForgeTool.getPlayerModel((EntityPlayerMP)event.player);
        PlayerJoinEvent forgePlayerLoggedInEvent = new PlayerJoinEvent(player);
        GlobalContext.sendEvent(forgePlayerLoggedInEvent);
    }

    @SubscribeEvent
    public void onPlayerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerQuit()) {
            return;
        }
        PlayerModel player = ForgeTool.getPlayerModel((EntityPlayerMP)event.player);
        PlayerQuitEvent forgePlayerLoggedOutEvent = new PlayerQuitEvent(player);
        GlobalContext.sendEvent(forgePlayerLoggedOutEvent);
    }

    @SubscribeEvent
    public void onPlayerCommand(CommandEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerCommand()) {
            return;
        }
        if (!(event.sender instanceof EntityPlayerMP)) {
            return;
        }
        ICommand iCommand = event.command;
        String command = Tool.isIgnoredCommand(iCommand.toString());
        if (command.isEmpty()) {
            return;
        }
        PlayerModel player = ForgeTool.getPlayerModel((EntityPlayerMP)event.sender);
        PlayerCommandEvent forgeCommandEvent = new PlayerCommandEvent(player, "", command, command);
        GlobalContext.sendEvent(forgeCommandEvent);
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerDeath()) {
            return;
        }
        if (!(event.entityLiving instanceof EntityPlayerMP)) {
            return;
        }
        IChatComponent component = event.source.func_151519_b(event.entityLiving);
        String reason = event.source.func_151519_b(event.entityLiving).func_150260_c();
        DeathModel death = new DeathModel();
        death.setText(reason);
        if (component instanceof ChatComponentTranslation) {
            ChatComponentTranslation chatComponentTranslation = (ChatComponentTranslation)component;
            String key = chatComponentTranslation.func_150268_i();
            String[] args = (String[])Arrays.stream(chatComponentTranslation.func_150271_j()).map(obj -> {
                if (obj instanceof IChatComponent) {
                    return ((IChatComponent)obj).func_150260_c();
                }
                return String.valueOf(obj);
            }).toArray(String[]::new);
            death.setKey(key);
            death.setArgs(args);
        }
        PlayerModel player = ForgeTool.getPlayerModel((EntityPlayerMP)event.entityLiving);
        PlayerDeathEvent forgeCommandEvent = new PlayerDeathEvent(player, death);
        GlobalContext.sendEvent(forgeCommandEvent);
    }

    @SubscribeEvent
    public void onPlayerAdvancementEvent(AchievementEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerAdvancement()) {
            return;
        }
        Achievement achievement = event.achievement;
        if (achievement.field_75975_e == null || achievement.field_75975_e.isEmpty() || achievement.field_75975_e.equals("achievement.openInventory")) {
            return;
        }
        if (achievement.func_150951_e() == null) {
            return;
        }
        PlayerModel playerModel = ForgeTool.getPlayerModel((EntityPlayerMP)event.entityPlayer);
        AchievementModel achievementModel = ForgeTool.getForgeAchievement(achievement);
        String text = achievementModel.pattern(achievementModel.getDisplay().getFrame(), playerModel.getNickname(), "[" + achievement.func_150951_e().func_150260_c() + "]");
        achievementModel.setText(text);
        PlayerAchievementEvent forgeAdvancementEvent = new PlayerAchievementEvent(playerModel, achievementModel);
        GlobalContext.sendEvent(forgeAdvancementEvent);
    }
}

