/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao;

import com.github.theword.queqiao.QueQiao;
import com.github.theword.queqiao.event.folia.FoliaAsyncPlayerChatEvent;
import com.github.theword.queqiao.event.folia.FoliaPlayerAdvancementDoneEvent;
import com.github.theword.queqiao.event.folia.FoliaPlayerCommandPreprocessEvent;
import com.github.theword.queqiao.event.folia.FoliaPlayerDeathEvent;
import com.github.theword.queqiao.event.folia.FoliaPlayerJoinEvent;
import com.github.theword.queqiao.event.folia.FoliaPlayerQuitEvent;
import com.github.theword.queqiao.event.folia.dto.advancement.FoliaAdvancement;
import com.github.theword.queqiao.handle.HandleApiImpl;
import com.github.theword.queqiao.handle.HandleCommandReturnMessageImpl;
import com.github.theword.queqiao.tool.GlobalContext;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.FoliaTool;
import io.papermc.paper.event.player.AsyncChatEvent;
import net.kyori.adventure.text.Component;
import org.bukkit.advancement.Advancement;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerLoadEvent;

class EventProcessor
implements Listener {
    EventProcessor() {
    }

    @EventHandler
    public void onServerLoad(ServerLoadEvent event) {
        GlobalContext.init(false, QueQiao.instance.getServer().getVersion(), "spigot", new HandleApiImpl(), new HandleCommandReturnMessageImpl());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void onPlayerChat(AsyncChatEvent event) {
        if (event.isCancelled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerChat()) {
            return;
        }
        FoliaAsyncPlayerChatEvent foliaAsyncPlayerChatEvent = new FoliaAsyncPlayerChatEvent(FoliaTool.getFoliaPlayer(event.getPlayer()), FoliaTool.getComponentText(event.message()));
        GlobalContext.getWebsocketManager().sendEvent(foliaAsyncPlayerChatEvent);
    }

    @EventHandler
    void onPlayerDeath(PlayerDeathEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerDeath()) {
            return;
        }
        Component component = event.deathMessage();
        if (component == null) {
            return;
        }
        String string = FoliaTool.getComponentText(component);
        FoliaPlayerDeathEvent foliaPlayerDeathEvent = new FoliaPlayerDeathEvent(FoliaTool.getFoliaPlayer(event.getEntity()), string);
        GlobalContext.getWebsocketManager().sendEvent(foliaPlayerDeathEvent);
    }

    @EventHandler
    void onPlayerJoin(PlayerJoinEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerJoin()) {
            return;
        }
        FoliaPlayerJoinEvent foliaPlayerJoinEvent = new FoliaPlayerJoinEvent(FoliaTool.getFoliaPlayer(event.getPlayer()));
        GlobalContext.getWebsocketManager().sendEvent(foliaPlayerJoinEvent);
    }

    @EventHandler
    void onPlayerQuit(PlayerQuitEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerQuit()) {
            return;
        }
        FoliaPlayerQuitEvent foliaPlayerQuitEvent = new FoliaPlayerQuitEvent(FoliaTool.getFoliaPlayer(event.getPlayer()));
        GlobalContext.getWebsocketManager().sendEvent(foliaPlayerQuitEvent);
    }

    @EventHandler
    void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerCommand()) {
            return;
        }
        String command = Tool.isRegisterOrLoginCommand(event.getMessage());
        if (command.isEmpty()) {
            return;
        }
        FoliaPlayerCommandPreprocessEvent foliaPlayerCommandPreprocessEvent = new FoliaPlayerCommandPreprocessEvent(FoliaTool.getFoliaPlayer(event.getPlayer()), command);
        GlobalContext.getWebsocketManager().sendEvent(foliaPlayerCommandPreprocessEvent);
    }

    @EventHandler
    void onPlayerAdvancement(PlayerAdvancementDoneEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerAdvancement()) {
            return;
        }
        Advancement advancement = event.getAdvancement();
        FoliaAdvancement foliaAdvancement = FoliaTool.getFoliaAdvancement(advancement);
        FoliaPlayerAdvancementDoneEvent foliaPlayerAdvancementDoneEvent = new FoliaPlayerAdvancementDoneEvent(FoliaTool.getFoliaPlayer(event.getPlayer()), foliaAdvancement);
        GlobalContext.getWebsocketManager().sendEvent(foliaPlayerAdvancementDoneEvent);
    }
}

