/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.tool.command.subCommand.client;

import com.github.theword.queqiao.tool.GlobalContext;
import com.github.theword.queqiao.tool.command.subCommand.ClientCommandAbstract;
import com.github.theword.queqiao.tool.websocket.WsClient;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ReconnectCommandAbstract
extends ClientCommandAbstract {
    @Override
    public String getName() {
        return "reconnect";
    }

    @Override
    public String getDescription() {
        return "\u91cd\u65b0\u8fde\u63a5 Websocket Clients";
    }

    @Override
    public String getUsage() {
        return super.getUsage() + " reconnect [all]";
    }

    @Override
    public String getPermissionNode() {
        return super.getPermissionNode() + ".reconnect";
    }

    @Override
    public void execute(Object commandReturner) {
        this.execute(commandReturner, false);
    }

    @Override
    public void execute(Object commandReturner, boolean all) {
        String reconnectCount = all ? "\u6b63\u5728\u91cd\u8fde\u6240\u6709 Websocket Client..." : "\u5b58\u5728\u672a\u5904\u4e8e\u6253\u5f00\u72b6\u6001\u7684 Websocket Client...";
        GlobalContext.getHandleCommandReturnMessageService().sendReturnMessage(commandReturner, reconnectCount);
        AtomicInteger opened = new AtomicInteger();
        List<WsClient> wsClientList = GlobalContext.getWebsocketManager().getWsClientList();
        wsClientList.forEach(wsClient -> {
            if (all || !wsClient.isOpen()) {
                wsClient.reconnectNow();
                GlobalContext.getHandleCommandReturnMessageService().sendReturnMessage(commandReturner, String.format("\u6b63\u5728\u5c1d\u8bd5\u91cd\u8fde %s \u7684 WebSocket \u5ba2\u6237\u7aef...", wsClient.getURI()));
            } else {
                opened.getAndIncrement();
            }
        });
        if (opened.get() == wsClientList.size()) {
            GlobalContext.getHandleCommandReturnMessageService().sendReturnMessage(commandReturner, "\u6ca1\u6709\u5ba2\u6237\u7aef\u9700\u8981\u91cd\u8fde");
        }
        GlobalContext.getHandleCommandReturnMessageService().sendReturnMessage(commandReturner, "\u5df2\u91cd\u65b0\u8fde\u63a5");
    }
}

