/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.utils;

import com.github.theword.queqiao.event.folia.FoliaPlayer;
import com.github.theword.queqiao.event.folia.dto.advancement.AdvancementDisplayDTO;
import com.github.theword.queqiao.event.folia.dto.advancement.FoliaAdvancement;
import com.github.theword.queqiao.event.folia.dto.advancement.ItemMetaDTO;
import com.github.theword.queqiao.event.folia.dto.advancement.ItemStackDTO;
import com.google.common.collect.Multimap;
import io.papermc.paper.advancement.AdvancementDisplay;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.advancement.Advancement;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class FoliaTool {
    public static String getComponentText(Component component) {
        return (String)PlainTextComponentSerializer.plainText().serializeOr(component, (Object)"");
    }

    public static FoliaPlayer getFoliaPlayer(Player player) {
        FoliaPlayer foliaPlayer = new FoliaPlayer();
        foliaPlayer.setUuid(player.getUniqueId());
        foliaPlayer.setNickname(FoliaTool.getComponentText(player.displayName()));
        foliaPlayer.setDisplayName(FoliaTool.getComponentText(player.displayName()));
        foliaPlayer.setPlayerListName(FoliaTool.getComponentText(player.playerListName()));
        foliaPlayer.setAddress(Objects.requireNonNull(player.getAddress()).toString());
        foliaPlayer.setHealthScale(player.getHealthScale());
        foliaPlayer.setExp(player.getExp());
        foliaPlayer.setTotalExp(player.getTotalExperience());
        foliaPlayer.setLevel(player.getLevel());
        foliaPlayer.setLocale(player.locale().toString());
        foliaPlayer.setPing(player.getPing());
        foliaPlayer.setPlayerTime(player.getPlayerTime());
        foliaPlayer.setPlayerTimeRelative(player.isPlayerTimeRelative());
        foliaPlayer.setPlayerTimeOffset(player.getPlayerTimeOffset());
        foliaPlayer.setWalkSpeed(player.getWalkSpeed());
        foliaPlayer.setFlySpeed(player.getFlySpeed());
        foliaPlayer.setAllowFlight(player.getAllowFlight());
        foliaPlayer.setSprinting(player.isSprinting());
        foliaPlayer.setSneaking(player.isSneaking());
        foliaPlayer.setFlying(player.isFlying());
        foliaPlayer.setOp(player.isOp());
        return foliaPlayer;
    }

    public static ItemMetaDTO getItemMetaDTO(ItemMeta itemMeta) {
        ItemMetaDTO itemMetaDTO = new ItemMetaDTO();
        if (itemMeta.hasCustomName()) {
            itemMetaDTO.setCustomName(itemMeta.customName().toString());
        }
        if (itemMeta.hasLore()) {
            List<String> collect = itemMeta.lore().stream().map(Component::toString).collect(Collectors.toList());
            itemMetaDTO.setLore(collect);
        }
        if (itemMeta.hasCustomModelData()) {
            itemMetaDTO.setCustomModelData(itemMeta.getCustomModelData());
        }
        if (itemMeta.hasEnchants()) {
            itemMetaDTO.setEnchants(itemMeta.getEnchants());
        }
        itemMetaDTO.setItemFlags(itemMeta.getItemFlags());
        itemMetaDTO.setUnbreakable(itemMeta.isUnbreakable());
        if (itemMeta.hasAttributeModifiers()) {
            itemMetaDTO.setAttributeModifiers((Multimap<Attribute, AttributeModifier>)itemMeta.getAttributeModifiers());
        }
        return itemMetaDTO;
    }

    public static ItemStackDTO getItemStackDTO(ItemStack itemStack) {
        ItemStackDTO itemStackDTO = new ItemStackDTO();
        itemStackDTO.setAmount(itemStack.getAmount());
        itemStackDTO.setMaterial(itemStack.getType().name());
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            ItemMetaDTO itemMetaDTO = FoliaTool.getItemMetaDTO(itemMeta);
            itemStackDTO.setMeta(itemMetaDTO);
        }
        return itemStackDTO;
    }

    public static FoliaAdvancement getFoliaAdvancement(Advancement advancement) {
        AdvancementDisplayDTO advancementDisplayDTO;
        AdvancementDisplay advancementDisplay = advancement.getDisplay();
        if (advancementDisplay != null) {
            ItemStackDTO itemStackDTO = FoliaTool.getItemStackDTO(advancementDisplay.icon());
            advancementDisplayDTO = new AdvancementDisplayDTO();
            advancementDisplayDTO.setTitle(FoliaTool.getComponentText(advancementDisplay.title()));
            advancementDisplayDTO.setDescription(FoliaTool.getComponentText(advancementDisplay.description()));
            advancementDisplayDTO.setIcon(itemStackDTO);
            advancementDisplayDTO.setDoesShowToast(advancementDisplay.doesShowToast());
            advancementDisplayDTO.setDoesAnnounceToChat(advancementDisplay.doesAnnounceToChat());
            advancementDisplayDTO.setIsHidden(advancementDisplay.isHidden());
            advancementDisplayDTO.setFrame(advancementDisplay.frame());
        } else {
            advancementDisplayDTO = null;
        }
        FoliaAdvancement foliaAdvancement = new FoliaAdvancement(advancement.getCriteria(), advancementDisplayDTO);
        foliaAdvancement.setText(advancementDisplay != null ? FoliaTool.getComponentText(advancementDisplay.title()) : "");
        return foliaAdvancement;
    }
}

