/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao;

import com.github.theword.queqiao.QueQiao;
import com.github.theword.queqiao.tool.GlobalContext;
import com.github.theword.queqiao.tool.event.PlayerAchievementEvent;
import com.github.theword.queqiao.tool.event.PlayerChatEvent;
import com.github.theword.queqiao.tool.event.PlayerCommandEvent;
import com.github.theword.queqiao.tool.event.PlayerDeathEvent;
import com.github.theword.queqiao.tool.event.PlayerJoinEvent;
import com.github.theword.queqiao.tool.event.PlayerQuitEvent;
import com.github.theword.queqiao.tool.event.base.BaseEvent;
import com.github.theword.queqiao.tool.event.model.PlayerModel;
import com.github.theword.queqiao.tool.event.model.achievement.AchievementModel;
import com.github.theword.queqiao.tool.event.model.death.DeathModel;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.ForgeTool;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventProcessor {
    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerChat()) {
            return;
        }
        PlayerModel player = ForgeTool.getForgePlayer(event.getPlayer());
        String message = event.getMessage().getString();
        String rawMessage = Component.Serializer.m_130703_((Component)event.getMessage(), (HolderLookup.Provider)QueQiao.minecraftServer.m_206579_());
        PlayerChatEvent forgeServerChatEvent = new PlayerChatEvent(player, "", rawMessage, message);
        GlobalContext.sendEvent((BaseEvent)forgeServerChatEvent);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerJoin()) {
            return;
        }
        PlayerModel player = ForgeTool.getForgePlayer((ServerPlayer)event.getEntity());
        PlayerJoinEvent forgePlayerLoggedInEvent = new PlayerJoinEvent(player);
        GlobalContext.sendEvent((BaseEvent)forgePlayerLoggedInEvent);
    }

    @SubscribeEvent
    public void onPlayerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerQuit()) {
            return;
        }
        PlayerModel player = ForgeTool.getForgePlayer((ServerPlayer)event.getEntity());
        PlayerQuitEvent forgePlayerLoggedOutEvent = new PlayerQuitEvent(player);
        GlobalContext.sendEvent((BaseEvent)forgePlayerLoggedOutEvent);
    }

    @SubscribeEvent
    public void onPlayerCommand(CommandEvent event) {
        PlayerModel player;
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerCommand()) {
            return;
        }
        if (!((CommandSourceStack)event.getParseResults().getContext().getSource()).m_230897_()) {
            return;
        }
        String command = Tool.isRegisterOrLoginCommand((String)event.getParseResults().getReader().getString());
        String rawMessage = event.getParseResults().getContext().toString();
        if (command.isEmpty()) {
            return;
        }
        try {
            player = ForgeTool.getForgePlayer(((CommandSourceStack)event.getParseResults().getContext().getSource()).m_81375_());
        }
        catch (CommandSyntaxException e) {
            return;
        }
        PlayerCommandEvent forgeCommandEvent = new PlayerCommandEvent(player, "", rawMessage, command);
        GlobalContext.sendEvent((BaseEvent)forgeCommandEvent);
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.isCanceled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerDeath()) {
            return;
        }
        DeathModel deathModel = new DeathModel();
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        PlayerModel player = ForgeTool.getForgePlayer((ServerPlayer)event.getEntity());
        LivingEntity entity = event.getEntity();
        Component localizedDeathMessage = event.getSource().m_6157_(entity);
        if (localizedDeathMessage instanceof TranslatableContents) {
            TranslatableContents translationTextComponent = (TranslatableContents)localizedDeathMessage;
            deathModel.setKey(translationTextComponent.m_237508_());
            String[] args = (String[])Arrays.stream(translationTextComponent.m_237523_()).map(arg -> {
                if (arg instanceof Component) {
                    return ((Component)arg).getString();
                }
                return String.valueOf(arg);
            }).toArray(String[]::new);
            deathModel.setArgs((Object)args);
        }
        deathModel.setText(localizedDeathMessage.getString());
        PlayerDeathEvent forgeCommandEvent = new PlayerDeathEvent(player, deathModel);
        GlobalContext.sendEvent((BaseEvent)forgeCommandEvent);
    }

    @SubscribeEvent
    public void onPlayerAdvancement(AdvancementEvent.AdvancementEarnEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerAdvancement()) {
            return;
        }
        Advancement advancement = event.getAdvancement().f_290952_();
        if (advancement.f_138299_().isEmpty() || !((DisplayInfo)advancement.f_138299_().get()).m_14996_()) {
            return;
        }
        PlayerModel player = ForgeTool.getForgePlayer((ServerPlayer)event.getEntity());
        AchievementModel achievementModel = ForgeTool.getForgeAchievement(advancement);
        if (advancement.f_291795_().isEmpty()) {
            return;
        }
        String advancementText = achievementModel.pattern(achievementModel.getDisplay().getFrame(), player.getNickname(), ((Component)advancement.f_291795_().get()).getString());
        achievementModel.setText(advancementText);
        PlayerAchievementEvent forgeAdvancementEvent = new PlayerAchievementEvent(player, achievementModel);
        GlobalContext.sendEvent((BaseEvent)forgeAdvancementEvent);
    }
}

