/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.tool.config;

import com.github.theword.queqiao.tool.config.CommonConfig;
import com.github.theword.queqiao.tool.config.RconConfig;
import com.github.theword.queqiao.tool.config.SubscribeEventConfig;
import com.github.theword.queqiao.tool.config.WebSocketClientConfig;
import com.github.theword.queqiao.tool.config.WebSocketServerConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class Config
extends CommonConfig {
    private boolean enable = true;
    private boolean debug = false;
    private String serverName = "Server";
    private String accessToken = "";
    private String messagePrefix = "[\u9e4a\u6865]";
    private Set<String> ignoredCommands;
    private WebSocketServerConfig websocketServer = new WebSocketServerConfig();
    private WebSocketClientConfig websocketClient = new WebSocketClientConfig();
    private SubscribeEventConfig subscribeEvent = new SubscribeEventConfig();
    private RconConfig rcon = new RconConfig();

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    public Set<String> getIgnoredCommands() {
        return this.ignoredCommands;
    }

    public void setIgnoredCommands(Set<String> ignoredCommands) {
        this.ignoredCommands = ignoredCommands;
    }

    public void setMessagePrefix(String messagePrefix) {
        this.messagePrefix = messagePrefix;
    }

    public WebSocketServerConfig getWebsocketServer() {
        return this.websocketServer;
    }

    public void setWebsocketServer(WebSocketServerConfig websocketServer) {
        this.websocketServer = websocketServer;
    }

    public WebSocketClientConfig getWebsocketClient() {
        return this.websocketClient;
    }

    public void setWebsocketClient(WebSocketClientConfig websocketClient) {
        this.websocketClient = websocketClient;
    }

    public SubscribeEventConfig getSubscribeEvent() {
        return this.subscribeEvent;
    }

    public void setSubscribeEvent(SubscribeEventConfig subscribeEvent) {
        this.subscribeEvent = subscribeEvent;
    }

    public RconConfig getRcon() {
        return this.rcon;
    }

    public void setRcon(RconConfig rcon) {
        this.rcon = rcon;
    }

    public Config(boolean isModServer, Logger logger) {
        super(logger);
        String configFolder = isModServer ? "config" : "plugins";
        String serverType = isModServer ? "\u6a21\u7ec4" : "\u63d2\u4ef6";
        logger.info("\u5f53\u524d\u670d\u52a1\u7aef\u7c7b\u578b\u4e3a\uff1a{}\u670d", (Object)serverType);
        this.readConfigFile(configFolder, "config.yml");
    }

    public static Config loadConfig(boolean isModServer, Logger logger) {
        return new Config(isModServer, logger);
    }

    @Override
    protected void loadConfigValues(Map<String, Object> configMap) {
        this.enable = (Boolean)configMap.get("enable");
        this.debug = (Boolean)configMap.get("debug");
        this.serverName = (String)configMap.get("server_name");
        this.accessToken = (String)configMap.get("access_token");
        this.messagePrefix = (String)configMap.get("message_prefix");
        this.loadIgnoredCommands(configMap);
        this.loadWebsocketServerConfig(configMap);
        this.loadWebsocketClientConfig(configMap);
        this.loadSubscribeEventConfig(configMap);
        this.loadRconConfig(configMap);
    }

    private void loadIgnoredCommands(Map<String, Object> configMap) {
        if (this.ignoredCommands == null) {
            this.ignoredCommands = new HashSet<String>();
        } else {
            this.ignoredCommands.clear();
        }
        List ignoredCommandList = (List)configMap.get("ignored_commands");
        if (ignoredCommandList == null) {
            super.getLogger().info("\u914d\u7f6e\u9879 ignored_commands \u4e3a\u7a7a\uff0c\u5c06\u53ea\u5ffd\u7565\u9ed8\u8ba4\u7684\u6ce8\u518c\u548c\u767b\u5f55\u547d\u4ee4");
        } else {
            this.ignoredCommands.addAll(ignoredCommandList);
            super.getLogger().info("\u5df2\u52a0\u8f7d {} \u4e2a\u5ffd\u7565\u7684\u547d\u4ee4", (Object)ignoredCommandList.size());
        }
        this.ignoredCommands.add("l");
        this.ignoredCommands.add("login");
        this.ignoredCommands.add("register");
        this.ignoredCommands.add("reg");
    }

    private void loadRconConfig(Map<String, Object> configMap) {
        Object rconObj = configMap.get("rcon");
        if (!(rconObj instanceof Map)) {
            return;
        }
        Map rconConfig = (Map)rconObj;
        this.rcon.setEnable(rconConfig.getOrDefault("enable", false));
        this.rcon.setPort(rconConfig.getOrDefault("port", 25575));
        this.rcon.setPassword(rconConfig.getOrDefault("password", ""));
    }

    private void loadWebsocketServerConfig(Map<String, Object> configMap) {
        Map websocketServerConfig = (Map)configMap.get("websocket_server");
        this.websocketServer.setEnable((Boolean)websocketServerConfig.get("enable"));
        this.websocketServer.setHost((String)websocketServerConfig.get("host"));
        this.websocketServer.setPort((Integer)websocketServerConfig.get("port"));
    }

    private void loadWebsocketClientConfig(Map<String, Object> configMap) {
        Map websocketClientConfig = (Map)configMap.get("websocket_client");
        this.websocketClient.setEnable((Boolean)websocketClientConfig.get("enable"));
        this.websocketClient.setReconnectInterval((Integer)websocketClientConfig.get("reconnect_interval"));
        this.websocketClient.setReconnectMaxTimes((Integer)websocketClientConfig.get("reconnect_max_times"));
        this.websocketClient.setUrlList((List)websocketClientConfig.get("url_list"));
    }

    private void loadSubscribeEventConfig(Map<String, Object> configMap) {
        Map subscribeEventConfig = (Map)configMap.get("subscribe_event");
        this.subscribeEvent.setPlayerChat((Boolean)subscribeEventConfig.get("player_chat"));
        this.subscribeEvent.setPlayerCommand((Boolean)subscribeEventConfig.get("player_command"));
        this.subscribeEvent.setPlayerDeath((Boolean)subscribeEventConfig.get("player_death"));
        this.subscribeEvent.setPlayerJoin((Boolean)subscribeEventConfig.get("player_join"));
        this.subscribeEvent.setPlayerQuit((Boolean)subscribeEventConfig.get("player_quit"));
        this.subscribeEvent.setPlayerAdvancement((Boolean)subscribeEventConfig.get("player_advancement"));
    }
}

