/*
 * Decompiled with CFR 0.152.
 */
package me.felixsoftwind.realisticsleep;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.Furnace;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class RealisticSleepPlugin
extends JavaPlugin
implements Listener {
    private final Map<World, ScheduledTask> activeTasks = new HashMap<World, ScheduledTask>();
    private final Map<World, Long> sleepStartTime = new HashMap<World, Long>();
    private final Map<World, Integer> originalRandomTickSpeed = new HashMap<World, Integer>();
    private ScheduledTask monitorTask;
    private int timeIncrement;
    private double randomTickMultiplier;
    private static final int NIGHT_START = 12541;
    private static final int NIGHT_END = 23459;
    private static final int DEFAULT_RANDOM_TICK = 3;
    private static final int RANDOM_TICK_MIN = 0;
    private static final int RANDOM_TICK_MAX = 1024;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.monitorTask = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this, scheduledTask -> {
            for (World world : Bukkit.getWorlds()) {
                if (world.getEnvironment() != World.Environment.NORMAL || this.activeTasks.containsKey(world) || !this.isSleepTime(world) || !this.areAllPlayersSleeping(world)) continue;
                this.startAcceleratedTime(world);
            }
        }, 1L, 1L);
        this.getLogger().info("\ud83c\udf19 RealisticSleep enabled for Folia.");
        this.getLogger().info("   Speed: " + this.timeIncrement + "x");
        this.getLogger().info("   Random tick multiplier: " + String.format("%.2f", this.randomTickMultiplier) + "x");
    }

    public void onDisable() {
        this.activeTasks.values().forEach(scheduledTask -> {
            if (scheduledTask != null) {
                scheduledTask.cancel();
            }
        });
        this.activeTasks.clear();
        this.sleepStartTime.clear();
        if (this.monitorTask != null) {
            this.monitorTask.cancel();
            this.monitorTask = null;
        }
        Bukkit.getGlobalRegionScheduler().run((Plugin)this, scheduledTask -> {
            for (World world : Bukkit.getWorlds()) {
                Integer n = this.originalRandomTickSpeed.get(world);
                if (n == null) continue;
                world.setGameRule(GameRule.RANDOM_TICK_SPEED, (Object)n);
            }
        });
        this.originalRandomTickSpeed.clear();
    }

    private void loadConfigValues() {
        this.timeIncrement = Math.max(1, this.getConfig().getInt("time_increment", 40));
        double d = this.getConfig().getDouble("random_tick_multiplier", -1.0);
        this.randomTickMultiplier = d == -1.0 ? (double)this.timeIncrement : Math.max(0.0, d);
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!command.getName().equalsIgnoreCase("realisticsleep")) {
            return false;
        }
        if (stringArray.length > 0 && stringArray[0].equalsIgnoreCase("reload")) {
            if (!commandSender.hasPermission("realisticsleep.reload")) {
                commandSender.sendMessage(Component.text((String)"You don't have permission to run this command!").color((TextColor)NamedTextColor.RED));
                return true;
            }
            for (World world : new HashMap<World, ScheduledTask>(this.activeTasks).keySet()) {
                this.stopAcceleratedTime(world);
            }
            this.reloadConfig();
            this.loadConfigValues();
            commandSender.sendMessage(Component.text((String)"\ud83c\udf19 RealisticSleep reloaded!").color((TextColor)NamedTextColor.GREEN));
            commandSender.sendMessage(Component.text((String)("   Speed: " + this.timeIncrement + "x")).color((TextColor)NamedTextColor.GRAY));
            commandSender.sendMessage(Component.text((String)("   Random tick multiplier: " + String.format("%.2f", this.randomTickMultiplier) + "x")).color((TextColor)NamedTextColor.GRAY));
            this.getLogger().info("Plugin reloaded by " + commandSender.getName());
            return true;
        }
        commandSender.sendMessage(Component.text((String)"=== RealisticSleep ===").color((TextColor)NamedTextColor.GOLD));
        commandSender.sendMessage(((TextComponent)Component.text((String)"/realisticsleep reload").color((TextColor)NamedTextColor.YELLOW)).append(Component.text((String)" - Reload config").color((TextColor)NamedTextColor.GRAY)));
        return true;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTimeSkip(TimeSkipEvent timeSkipEvent) {
        World world;
        if (timeSkipEvent.getSkipReason() == TimeSkipEvent.SkipReason.NIGHT_SKIP && (world = timeSkipEvent.getWorld()) != null && this.activeTasks.containsKey(world)) {
            timeSkipEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBedEnter(PlayerBedEnterEvent playerBedEnterEvent) {
        if (playerBedEnterEvent.getBedEnterResult() != PlayerBedEnterEvent.BedEnterResult.OK) {
            return;
        }
        World world = playerBedEnterEvent.getPlayer().getWorld();
        Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this, scheduledTask -> {
            if (!this.activeTasks.containsKey(world) && this.isSleepTime(world) && this.areAllPlayersSleeping(world)) {
                this.startAcceleratedTime(world);
            }
        }, 5L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBedLeave(PlayerBedLeaveEvent playerBedLeaveEvent) {
        World world = playerBedLeaveEvent.getPlayer().getWorld();
        Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this, scheduledTask -> {
            if (!this.areAllPlayersSleeping(world)) {
                this.stopAcceleratedTime(world);
            }
        }, 5L);
    }

    private boolean areAllPlayersSleeping(World world) {
        int n = 0;
        int n2 = 0;
        for (Player player : world.getPlayers()) {
            if (player.getGameMode() == GameMode.SPECTATOR || player.isSleepingIgnored()) continue;
            ++n;
            if (!player.isSleeping() && !player.isDeeplySleeping()) continue;
            ++n2;
        }
        return n > 0 && n2 == n;
    }

    private boolean isSleepTime(World world) {
        long l = world.getTime() % 24000L;
        boolean bl = l >= 12541L && l < 23459L;
        boolean bl2 = world.isThundering();
        return bl || bl2;
    }

    private void startAcceleratedTime(World world) {
        if (this.activeTasks.containsKey(world)) {
            return;
        }
        this.sleepStartTime.put(world, world.getTime());
        Integer n = (Integer)world.getGameRuleValue(GameRule.RANDOM_TICK_SPEED);
        if (n == null) {
            n = 3;
        }
        this.originalRandomTickSpeed.putIfAbsent(world, n);
        int n2 = this.originalRandomTickSpeed.getOrDefault(world, 3);
        int n3 = RealisticSleepPlugin.clampInt((int)Math.round((double)n2 * this.randomTickMultiplier), 0, 1024);
        if (n3 != n2) {
            world.setGameRule(GameRule.RANDOM_TICK_SPEED, (Object)n3);
            this.getLogger().info("Adjusting random ticks: " + n2 + " -> " + n3);
        }
        ScheduledTask scheduledTask2 = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this, scheduledTask -> {
            if (!this.areAllPlayersSleeping(world) || !this.isSleepTime(world)) {
                this.stopAcceleratedTime(world);
                return;
            }
            long l = world.getTime();
            world.setTime(l + (long)this.timeIncrement);
            this.accelerateWorldTicks(world);
            int n = this.nightPercent(world);
            Component component = Component.text((String)("\ud83c\udf19 " + n + "%")).color((TextColor)NamedTextColor.GOLD);
            for (Object object : world.getPlayers()) {
                object.sendActionBar(component);
            }
            if (!this.isSleepTime(world)) {
                this.stopAcceleratedTime(world);
                Component component2 = Component.text((String)"\u2600 Good morning!").color((TextColor)NamedTextColor.YELLOW);
                for (Player player : world.getPlayers()) {
                    player.sendActionBar(component2);
                }
            }
        }, 1L, 1L);
        this.activeTasks.put(world, scheduledTask2);
        this.getLogger().info("Started accelerated sleep for world: " + world.getName());
    }

    private void stopAcceleratedTime(World world) {
        ScheduledTask scheduledTask = this.activeTasks.remove(world);
        if (scheduledTask != null) {
            scheduledTask.cancel();
            this.getLogger().info("Stopped accelerated sleep for world: " + world.getName());
        }
        this.sleepStartTime.remove(world);
        Integer n = this.originalRandomTickSpeed.get(world);
        if (n != null) {
            world.setGameRule(GameRule.RANDOM_TICK_SPEED, (Object)n);
            this.getLogger().info("Restored random tick speed to: " + n);
        }
    }

    private void accelerateWorldTicks(World world) {
        for (Chunk chunk : world.getLoadedChunks()) {
            Bukkit.getRegionScheduler().run((Plugin)this, chunk.getWorld(), chunk.getX(), chunk.getZ(), scheduledTask -> {
                int n;
                Furnace furnace;
                for (BlockState blockState : chunk.getTileEntities()) {
                    if (!(blockState instanceof Furnace)) continue;
                    furnace = (Furnace)blockState;
                    for (n = 0; n < Math.max(0, this.timeIncrement - 1); ++n) {
                        if (furnace.getCookTime() > 0) {
                            furnace.setCookTime((short)(furnace.getCookTime() + 1));
                        }
                        if (furnace.getBurnTime() <= 0) continue;
                        furnace.setBurnTime((short)(furnace.getBurnTime() - 1));
                    }
                    furnace.update(true, false);
                }
                for (BlockState blockState : chunk.getEntities()) {
                    if (!(blockState instanceof Ageable) || (furnace = (Ageable)blockState).isAdult() || (n = furnace.getAge()) >= 0) continue;
                    furnace.setAge(n + this.timeIncrement);
                }
            });
        }
    }

    private int nightPercent(World world) {
        long l = world.getTime() % 24000L;
        if (l < 12541L || l >= 23459L) {
            return 0;
        }
        long l2 = 10918L;
        long l3 = Math.max(0L, Math.min(l2, l - 12541L));
        return (int)(l3 * 100L / l2);
    }

    private static int clampInt(int n, int n2, int n3) {
        return Math.max(n2, Math.min(n3, n));
    }
}

