/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.notunanancyowen.components.AttackRange;
import com.notunanancyowen.components.KineticWeapon;
import com.notunanancyowen.components.PiercingWeapon;
import com.notunanancyowen.components.SwingAnimation;
import com.notunanancyowen.components.UseEffects;
import com.notunanancyowen.criteria.SpearedMobs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_179;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1835;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9698;
import net.minecraft.class_9721;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Spears {
    public static final String MOD_ID = "spears";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"spears");
    public static final class_9331<UseEffects> USE_EFFECTS = Spears.register("use_effects", builder -> builder.method_57881(UseEffects.CODEC).method_57882(UseEffects.PACKET_CODEC));
    public static final class_9331<AttackRange> ATTACK_RANGE = Spears.register("attack_range", builder -> builder.method_57881(AttackRange.CODEC).method_57882(AttackRange.PACKET_CODEC));
    public static final class_9331<KineticWeapon> KINETIC_WEAPON = Spears.register("kinetic_weapon", builder -> builder.method_57881(KineticWeapon.CODEC).method_57882(KineticWeapon.PACKET_CODEC));
    public static final class_9331<SwingAnimation> SWING_ANIMATION = Spears.register("swing_animation", builder -> builder.method_57881(SwingAnimation.CODEC).method_57882(SwingAnimation.PACKET_CODEC));
    public static final class_9331<PiercingWeapon> PIERCING_WEAPON = Spears.register("piercing_weapon", builder -> builder.method_57881(PiercingWeapon.CODEC).method_57882(PiercingWeapon.PACKET_CODEC));
    public static final class_9331<Float> MINIMUM_ATTACK_CHARGE = Spears.register("minimum_attack_charge", builder -> builder.method_57881(Spears.rangedInclusiveFloat(0.0f, 1.0f)).method_57882(class_9135.field_48552));
    public static final class_6880<class_3414> SPEAR_ATTACK = Spears.registerSound("item.spear.attack");
    public static final class_6880<class_3414> SPEAR_HIT = Spears.registerSound("item.spear.hit");
    public static final class_6880<class_3414> SPEAR_USE = Spears.registerSound("item.spear.use");
    public static final class_6880<class_3414> SPEAR_WOOD_ATTACK = Spears.registerSound("item.spear_wood.attack");
    public static final class_6880<class_3414> SPEAR_WOOD_HIT = Spears.registerSound("item.spear_wood.hit");
    public static final class_6880<class_3414> SPEAR_WOOD_USE = Spears.registerSound("item.spear_wood.use");
    public static final class_6880<class_3414> SPEAR_LUNGE = Spears.registerSound("item.spear.lunge");
    public static final class_6862<class_1792> SPEARS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60656((String)"spears"));
    public static final class_1792 WOODEN_SPEAR = Spears.registerSpear("wooden_spear", (class_1832)class_1834.field_8922, 0.65f, 0.7f, 0.75f, 5.0f, 14.0f, 6.0f, 5.1f, 15.0f, 4.6f);
    public static final class_1792 STONE_SPEAR = Spears.registerSpear("stone_spear", (class_1832)class_1834.field_8927, 0.75f, 0.82f, 0.7f, 4.5f, 10.0f, 5.5f, 5.1f, 13.75f, 4.6f);
    public static final class_1792 GOLDEN_SPEAR = Spears.registerSpear("golden_spear", (class_1832)class_1834.field_8929, 0.95f, 0.7f, 0.7f, 3.5f, 10.0f, 5.5f, 5.1f, 13.75f, 4.6f);
    public static final class_1792 IRON_SPEAR = Spears.registerSpear("iron_spear", (class_1832)class_1834.field_8923, 0.95f, 0.95f, 0.6f, 2.5f, 8.0f, 4.5f, 5.1f, 11.25f, 4.6f);
    public static final class_1792 DIAMOND_SPEAR = Spears.registerSpear("diamond_spear", (class_1832)class_1834.field_8930, 1.05f, 1.075f, 0.5f, 3.0f, 7.5f, 4.0f, 5.1f, 10.0f, 4.6f);
    public static final class_1792 NETHERITE_SPEAR = Spears.registerSpear("netherite_spear", (class_1832)class_1834.field_22033, 1.15f, 1.2f, 0.4f, 2.5f, 7.0f, 3.5f, 5.1f, 8.75f, 4.6f);
    public static class_9331<List<class_9698<class_9721>>> POST_PIERCING_ATTACK = Spears.registerEffect("post_piercing_attack", builder -> builder.method_57881(class_9698.method_60004((Codec)class_9721.field_51707, (class_176)class_173.field_51801).listOf()));
    public static final SpearedMobs SPEARED_MOBS = Spears.registerCriterion("spear_mobs", new SpearedMobs());
    public static HashMap<String, Boolean> config;
    public static boolean hasBetterCombat;

    public static Collection<class_3966> collectPiercingCollisions(class_1309 entity, float minReach, float maxReach, float hitboxMargin, Predicate<class_1297> hitPredicate) {
        class_243 vec3d = entity.method_5631(entity.method_36455(), entity.method_5791());
        class_243 vec3d2 = entity.method_33571();
        class_243 vec3d3 = vec3d2.method_1019(vec3d.method_1021((double)minReach));
        double d = entity.method_60478().method_1026(vec3d);
        class_243 vec3d4 = vec3d2.method_1019(vec3d.method_1021((double)maxReach + Math.max(0.0, d)));
        return (Collection)Spears.collectPiercingCollisions((class_1297)entity, vec3d2, vec3d3, hitPredicate, vec3d4, hitboxMargin, class_3959.class_3960.field_17558).map(hitResult -> List.of(), hitResults -> hitResults);
    }

    private static Either<class_3965, Collection<class_3966>> collectPiercingCollisions(class_1297 entity, class_243 pos, class_243 minReach, Predicate<class_1297> hitPredicate, class_243 maxReach, float hitboxMargin, class_3959.class_3960 shapeType) {
        class_1937 world = entity.method_5770();
        class_3965 blockHitResult = Spears.getCollisionsIncludingWorldBorder(world, new class_3959(pos, maxReach, shapeType, class_3959.class_242.field_1348, entity));
        if (blockHitResult.method_17783() != class_239.class_240.field_1333 && pos.method_1025(maxReach = blockHitResult.method_17784()) < pos.method_1025(minReach)) {
            return Either.left((Object)blockHitResult);
        }
        class_238 box = class_238.method_30048((class_243)minReach, (double)hitboxMargin, (double)hitboxMargin, (double)hitboxMargin).method_18804(maxReach.method_1020(minReach)).method_1014(1.0);
        Collection<class_3966> collection = Spears.collectPiercingCollisions(world, entity, minReach, maxReach, box, hitPredicate, hitboxMargin, shapeType, true);
        return !collection.isEmpty() ? Either.right(collection) : Either.left((Object)blockHitResult);
    }

    public static Collection<class_3966> collectPiercingCollisions(class_1937 world, class_1297 entity, class_243 from, class_243 to, class_238 box, Predicate<class_1297> hitPredicate, float hitboxMargin, class_3959.class_3960 shapeType, boolean bl) {
        ArrayList<class_3966> list = new ArrayList<class_3966>();
        for (class_1297 entity2 : world.method_8333(entity, box, hitPredicate)) {
            class_243 vec3d2;
            Optional optional2;
            class_238 box2 = entity2.method_5829();
            if (bl && box2.method_1006(from)) {
                list.add(new class_3966(entity2, from));
                continue;
            }
            Optional optional = box2.method_992(from, to);
            if (optional.isPresent()) {
                list.add(new class_3966(entity2, (class_243)optional.get()));
                continue;
            }
            if ((double)hitboxMargin <= 0.0 || !(optional2 = box2.method_1014((double)hitboxMargin).method_992(from, to)).isPresent()) continue;
            class_243 vec3d = (class_243)optional2.get();
            class_3965 blockHitResult = Spears.getCollisionsIncludingWorldBorder(world, new class_3959(vec3d, vec3d2 = box2.method_1005(), shapeType, class_3959.class_242.field_1348, entity));
            if (blockHitResult.method_17783() != class_239.class_240.field_1333) {
                vec3d2 = blockHitResult.method_17784();
            }
            Optional optional3 = entity2.method_5829().method_992(vec3d, vec3d2);
            optional3.ifPresent(d -> list.add(new class_3966(entity2, d)));
        }
        return list;
    }

    private static class_3965 getCollisionsIncludingWorldBorder(class_1937 world, class_3959 context) {
        class_3965 blockHitResult = world.method_17742(context);
        class_2784 worldBorder = world.method_8621();
        if (worldBorder.method_61115(context.method_17750()) && !worldBorder.method_61115(blockHitResult.method_17784())) {
            class_243 vec3d = blockHitResult.method_17784().method_1020(context.method_17750());
            class_2350 direction = class_2350.method_10142((double)vec3d.field_1352, (double)vec3d.field_1351, (double)vec3d.field_1350);
            class_243 vec3d2 = blockHitResult.method_17784();
            vec3d2 = new class_243(class_3532.method_15350((double)vec3d2.field_1352, (double)worldBorder.method_11976(), (double)(worldBorder.method_11963() - (double)1.0E-5f)), vec3d2.field_1351, class_3532.method_15350((double)vec3d2.field_1350, (double)worldBorder.method_11958(), (double)(worldBorder.method_11977() - (double)1.0E-5f)));
            return new class_3965(vec3d2, direction, class_2338.method_49638((class_2374)vec3d2), false);
        }
        return blockHitResult;
    }

    public static Codec<Float> rangedInclusiveFloat(float minInclusive, float maxInclusive, Function<Float, String> messageFactory) {
        return Codec.FLOAT.validate(value -> value.compareTo(Float.valueOf(minInclusive)) >= 0 && value.compareTo(Float.valueOf(maxInclusive)) <= 0 ? DataResult.success((Object)value) : DataResult.error(() -> (String)messageFactory.apply((Float)value)));
    }

    public static Codec<Float> rangedInclusiveFloat(float minInclusive, float maxInclusive) {
        return Spears.rangedInclusiveFloat(minInclusive, maxInclusive, value -> "Value must be within range [" + minInclusive + ";" + maxInclusive + "]: " + value);
    }

    public static <T> class_9331<T> register(String id, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return (class_9331)class_2378.method_10226((class_2378)class_7923.field_49658, (String)id, (Object)((class_9331.class_9332)builderOperator.apply(class_9331.method_57873())).method_57880());
    }

    private static class_6880<class_3414> registerSound(String id) {
        class_2960 identifier = class_2960.method_60656((String)id);
        return class_2378.method_47985((class_2378)class_7923.field_41172, (class_2960)identifier, (Object)class_3414.method_47908((class_2960)identifier));
    }

    public static class_1792 registerSpear(String id, class_1832 material, float swingAnimationSeconds, float chargeDamageMultiplier, float chargeDelaySeconds, float maxDurationForDismountSeconds, float minSpeedForDismount, float maxDurationForChargeKnockbackInSeconds, float minSpeedForChargeKnockback, float maxDurationForChargeDamageInSeconds, float minRelativeSpeedForChargeDamage) {
        boolean wood = material == class_1834.field_8922;
        class_1792.class_1793 components = new class_1792.class_1793().method_57349(USE_EFFECTS, (Object)new UseEffects(1.0f, true, false)).method_57348(class_9285.method_57480().method_57487(class_5134.field_23721, new class_1322(class_1792.field_8006, (double)material.method_8028(), class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_23723, new class_1322(class_1792.field_8001, (double)(1.0f / swingAnimationSeconds) - 4.0, class_1322.class_1323.field_6328), class_9274.field_49217).method_57486()).method_57349(MINIMUM_ATTACK_CHARGE, (Object)Float.valueOf(1.0f)).method_57349(ATTACK_RANGE, (Object)new AttackRange(2.0f, 4.5f));
        HashMap<String, Boolean> config = Spears.makeConfig();
        boolean chargeAttacksEnabled = config.getOrDefault("spear_charge_attacks", true);
        if (config.getOrDefault("spear_stabbing_animation", true).booleanValue()) {
            components.method_57349(SWING_ANIMATION, (Object)new SwingAnimation((int)(swingAnimationSeconds * 20.0f), "stab")).method_57349(PIERCING_WEAPON, (Object)new PiercingWeapon(0.25f, true, false, Optional.of(wood ? SPEAR_WOOD_ATTACK : SPEAR_ATTACK), Optional.of(wood ? SPEAR_WOOD_HIT : SPEAR_HIT)));
        }
        if (chargeAttacksEnabled) {
            components.method_57349(KINETIC_WEAPON, (Object)new KineticWeapon(0.125f, 10, (int)(chargeDelaySeconds * 20.0f), KineticWeapon.Condition.ofMinSpeed((int)(maxDurationForDismountSeconds * 20.0f), minSpeedForDismount), KineticWeapon.Condition.ofMinSpeed((int)(maxDurationForChargeKnockbackInSeconds * 20.0f), minSpeedForChargeKnockback), KineticWeapon.Condition.ofMinRelativeSpeed((int)(maxDurationForChargeDamageInSeconds * 20.0f), minRelativeSpeedForChargeDamage), 0.38f, chargeDamageMultiplier, Optional.of(wood ? SPEAR_WOOD_USE : SPEAR_USE), Optional.of(wood ? SPEAR_WOOD_HIT : SPEAR_HIT)));
        }
        if (material == class_1834.field_22033) {
            components.method_24359();
        }
        if (chargeAttacksEnabled) {
            return (class_1792)class_2378.method_10226((class_2378)class_7923.field_41178, (String)id, (Object)new class_1831(material, components){

                public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
                    if (selected) {
                        stack.method_27320(entity);
                    } else {
                        stack.method_27320(null);
                    }
                    super.method_7888(stack, world, entity, slot, selected);
                }

                public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
                    return !miner.method_7337();
                }

                public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
                    return true;
                }

                public void method_59978(class_1799 stack, class_1309 target, class_1309 attacker) {
                    stack.method_7970(1, attacker, class_1304.field_6173);
                }

                public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
                    user.method_6019(hand);
                    return class_1271.method_22428((Object)user.method_5998(hand));
                }

                public int method_7881(class_1799 stack, class_1309 user) {
                    return 72000;
                }
            });
        }
        return (class_1792)class_2378.method_10226((class_2378)class_7923.field_41178, (String)id, (Object)new class_1831(material, components){

            public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
                if (selected) {
                    stack.method_27320(entity);
                } else {
                    stack.method_27320(null);
                }
                super.method_7888(stack, world, entity, slot, selected);
            }

            public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
                return !miner.method_7337();
            }

            public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
                return true;
            }

            public void method_59978(class_1799 stack, class_1309 target, class_1309 attacker) {
                stack.method_7970(1, attacker, class_1304.field_6173);
            }
        });
    }

    private static <T> class_9331<T> registerEffect(String id, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return (class_9331)class_2378.method_10226((class_2378)class_7923.field_51832, (String)id, (Object)((class_9331.class_9332)builderOperator.apply(class_9331.method_57873())).method_57880());
    }

    private static <T extends class_179<?>> T registerCriterion(String id, T criterion) {
        return (T)((class_179)class_2378.method_10226((class_2378)class_7923.field_47496, (String)id, criterion));
    }

    public static HashMap<String, Boolean> makeConfig() {
        if (config == null) {
            config = new HashMap();
        }
        return config;
    }

    public static class_1792 TridentRegister() {
        class_1792.class_1793 components = new class_1792.class_1793().method_7894(class_1814.field_8904).method_7895(250).method_57348(class_1835.method_57395()).method_57349(class_9334.field_50077, (Object)class_1835.method_58420());
        if (Spears.makeConfig().getOrDefault("tridents_use_spear_attack_animation", false).booleanValue()) {
            components.method_57349(PIERCING_WEAPON, (Object)new PiercingWeapon(0.2f, true, false, Optional.of(class_3417.field_15001), Optional.empty())).method_57349(SWING_ANIMATION, (Object)new SwingAnimation(20, "stab")).method_57349(MINIMUM_ATTACK_CHARGE, (Object)Float.valueOf(0.9f)).method_57349(ATTACK_RANGE, (Object)new AttackRange(0.0f, 4.0f));
        }
        return class_1802.method_7991((String)"trident", (class_1792)new class_1835(components));
    }

    public static void init() {
        LOGGER.info("Backported spears!");
    }

    static {
        hasBetterCombat = false;
    }
}

