/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.notunanancyowen.PacketCodecHelper;
import com.notunanancyowen.Spears;
import com.notunanancyowen.components.AttackRange;
import com.notunanancyowen.components.PiercingWeapon;
import com.notunanancyowen.dataholders.SpearUser;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record KineticWeapon(float hitboxMargin, int contactCooldownTicks, int delayTicks, Optional<Condition> dismountConditions, Optional<Condition> knockbackConditions, Optional<Condition> damageConditions, float forwardMovement, float damageMultiplier, Optional<class_6880<class_3414>> sound, Optional<class_6880<class_3414>> hitSound) {
    public static final Codec<KineticWeapon> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Spears.rangedInclusiveFloat(0.0f, 1.0f).optionalFieldOf("hitbox_margin", (Object)Float.valueOf(0.3f)).forGetter(KineticWeapon::hitboxMargin), (App)class_5699.field_33441.optionalFieldOf("contact_cooldown_ticks", (Object)10).forGetter(KineticWeapon::contactCooldownTicks), (App)class_5699.field_33441.optionalFieldOf("delay_ticks", (Object)0).forGetter(KineticWeapon::delayTicks), (App)Condition.CODEC.optionalFieldOf("dismount_conditions").forGetter(KineticWeapon::dismountConditions), (App)Condition.CODEC.optionalFieldOf("knockback_conditions").forGetter(KineticWeapon::knockbackConditions), (App)Condition.CODEC.optionalFieldOf("damage_conditions").forGetter(KineticWeapon::damageConditions), (App)Codec.FLOAT.optionalFieldOf("forward_movement", (Object)Float.valueOf(0.0f)).forGetter(KineticWeapon::forwardMovement), (App)Codec.FLOAT.optionalFieldOf("damage_multiplier", (Object)Float.valueOf(1.0f)).forGetter(KineticWeapon::damageMultiplier), (App)class_3414.field_41699.optionalFieldOf("sound").forGetter(KineticWeapon::sound), (App)class_3414.field_41699.optionalFieldOf("hit_sound").forGetter(KineticWeapon::hitSound)).apply((Applicative)instance, KineticWeapon::new));
    public static final class_9139<class_9129, KineticWeapon> PACKET_CODEC = PacketCodecHelper.tuple(class_9135.field_48552, KineticWeapon::hitboxMargin, class_9135.field_48550, KineticWeapon::contactCooldownTicks, class_9135.field_48550, KineticWeapon::delayTicks, Condition.PACKET_CODEC.method_56433(class_9135::method_56382), KineticWeapon::dismountConditions, Condition.PACKET_CODEC.method_56433(class_9135::method_56382), KineticWeapon::knockbackConditions, Condition.PACKET_CODEC.method_56433(class_9135::method_56382), KineticWeapon::damageConditions, class_9135.field_48552, KineticWeapon::forwardMovement, class_9135.field_48552, KineticWeapon::damageMultiplier, class_3414.field_48279.method_56433(class_9135::method_56382), KineticWeapon::sound, class_3414.field_48279.method_56433(class_9135::method_56382), KineticWeapon::hitSound, KineticWeapon::new);

    public static class_243 getAmplifiedMovement(class_1297 entity) {
        class_243 class_2432;
        if (!(entity instanceof class_1657) && entity.method_5765()) {
            entity = entity.method_5668();
        }
        if (entity instanceof class_1657) {
            class_1657 p = (class_1657)entity;
            class_2432 = p.method_60478();
        } else {
            class_2432 = entity.method_19538().method_1023(entity.field_6014, entity.field_6036, entity.field_5969);
        }
        return class_2432.method_1021(20.0);
    }

    public void playSound(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 p = (class_1657)entity;
            this.sound.ifPresent(sound -> entity.method_5770().method_60511(p, entity.method_23317(), entity.method_23318(), entity.method_23321(), sound, entity.method_5634(), 1.0f, 1.0f));
        }
    }

    public void playHitSound(class_1297 entity) {
        this.hitSound.ifPresent(sound -> entity.method_5770().method_60511(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), sound, entity.method_5634(), 1.0f, 1.0f));
    }

    public int getUseTicks() {
        return this.delayTicks + this.damageConditions.map(Condition::maxDurationTicks).orElse(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void usageTick(class_1799 stack, int remainingUseTicks, class_1309 user, class_1304 slot) {
        Object attackRange;
        int i = stack.method_7935(user) - remainingUseTicks;
        if (i < this.delayTicks) return;
        if (!(user instanceof SpearUser)) return;
        SpearUser s = (SpearUser)user;
        i -= this.delayTicks;
        class_243 vec3d = user.method_5720();
        double d = vec3d.method_1026(KineticWeapon.getAmplifiedMovement((class_1297)user));
        float f = user instanceof class_1657 ? 1.0f : 0.2f;
        float g = user instanceof class_1657 ? 1.0f : 0.5f;
        double e = user.method_45326(class_5134.field_23721);
        boolean bl = false;
        float minReach = 0.0f;
        float maxReach = 3.0f;
        Object object = stack.method_57824(Spears.ATTACK_RANGE);
        if (object instanceof AttackRange) {
            attackRange = (AttackRange)object;
            try {
                float f2;
                float reachMin = f2 = ((AttackRange)attackRange).minReach();
                float reachMax = f2 = ((AttackRange)attackRange).maxReach();
                minReach = reachMin;
                maxReach = reachMax;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        attackRange = Spears.collectPiercingCollisions(user, g * minReach, g * maxReach, this.hitboxMargin, target -> PiercingWeapon.canHit((class_1297)user, target)).iterator();
        while (true) {
            boolean bl5;
            if (!attackRange.hasNext()) {
                if (!bl) return;
                this.playHitSound((class_1297)user);
                user.method_5770().method_8421((class_1297)user, (byte)2);
                if (!(user instanceof class_3222)) return;
                class_3222 serverPlayerEntity = (class_3222)user;
                Spears.SPEARED_MOBS.spearMob(serverPlayerEntity, s.countSpearedMobs());
                return;
            }
            class_3966 entityHitResult = (class_3966)attackRange.next();
            class_1297 entity = entityHitResult.method_17782();
            boolean bl2 = s.isInPiercingCooldown(entity, this.contactCooldownTicks);
            s.startPiercingCooldown(entity);
            if (bl2) continue;
            double j = Math.max(0.0, d - vec3d.method_1026(KineticWeapon.getAmplifiedMovement(entity)));
            boolean bl3 = this.dismountConditions.isPresent() && this.dismountConditions.get().isSatisfied(i, d, j, f);
            boolean bl4 = this.knockbackConditions.isPresent() && this.knockbackConditions.get().isSatisfied(i, d, j, f);
            boolean bl6 = bl5 = this.damageConditions.isPresent() && this.damageConditions.get().isSatisfied(i, d, j, f);
            if (!bl3 && !bl4 && !bl5) continue;
            float k = (float)e + (float)class_3532.method_15357((double)(j * (double)this.damageMultiplier));
            bl |= s.pierce(slot, entity, k, bl5, bl4, bl3);
        }
    }

    public record Condition(int maxDurationTicks, float minSpeed, float minRelativeSpeed) {
        public static final Codec<Condition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33441.fieldOf("max_duration_ticks").forGetter(Condition::maxDurationTicks), (App)Codec.FLOAT.optionalFieldOf("min_speed", (Object)Float.valueOf(0.0f)).forGetter(Condition::minSpeed), (App)Codec.FLOAT.optionalFieldOf("min_relative_speed", (Object)Float.valueOf(0.0f)).forGetter(Condition::minRelativeSpeed)).apply((Applicative)instance, Condition::new));
        public static final class_9139<ByteBuf, Condition> PACKET_CODEC = class_9139.method_56436((class_9139)class_9135.field_48550, Condition::maxDurationTicks, (class_9139)class_9135.field_48552, Condition::minSpeed, (class_9139)class_9135.field_48552, Condition::minRelativeSpeed, Condition::new);

        public boolean isSatisfied(int durationTicks, double speed, double relativeSpeed, double minSpeedMultiplier) {
            return durationTicks <= this.maxDurationTicks && speed >= (double)this.minSpeed * minSpeedMultiplier && relativeSpeed >= (double)this.minRelativeSpeed * minSpeedMultiplier;
        }

        public static Optional<Condition> ofMinSpeed(int maxDurationTicks, float minSpeed) {
            return Optional.of(new Condition(maxDurationTicks, minSpeed, 0.0f));
        }

        public static Optional<Condition> ofMinRelativeSpeed(int maxDurationTicks, float minRelativeSpeed) {
            return Optional.of(new Condition(maxDurationTicks, 0.0f, minRelativeSpeed));
        }
    }
}

