/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.notunanancyowen.Spears;
import com.notunanancyowen.components.AttackRange;
import com.notunanancyowen.dataholders.SpearUser;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3966;
import net.minecraft.class_47;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_8567;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9698;
import net.minecraft.class_9699;
import net.minecraft.class_9721;

public record PiercingWeapon(float hitboxMargin, boolean dealsKnockback, boolean dismounts, Optional<class_6880<class_3414>> sound, Optional<class_6880<class_3414>> hitSound) {
    public static final Codec<PiercingWeapon> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Spears.rangedInclusiveFloat(0.0f, 1.0f).optionalFieldOf("hitbox_margin", (Object)Float.valueOf(0.3f)).forGetter(PiercingWeapon::hitboxMargin), (App)Codec.BOOL.optionalFieldOf("deals_knockback", (Object)true).forGetter(PiercingWeapon::dealsKnockback), (App)Codec.BOOL.optionalFieldOf("dismounts", (Object)false).forGetter(PiercingWeapon::dismounts), (App)class_3414.field_41699.optionalFieldOf("sound").forGetter(PiercingWeapon::sound), (App)class_3414.field_41699.optionalFieldOf("hit_sound").forGetter(PiercingWeapon::hitSound)).apply((Applicative)instance, PiercingWeapon::new));
    public static final class_9139<class_9129, PiercingWeapon> PACKET_CODEC = class_9139.method_56906((class_9139)class_9135.field_48552, PiercingWeapon::hitboxMargin, (class_9139)class_9135.field_48547, PiercingWeapon::dealsKnockback, (class_9139)class_9135.field_48547, PiercingWeapon::dismounts, (class_9139)class_3414.field_48279.method_56433(class_9135::method_56382), PiercingWeapon::sound, (class_9139)class_3414.field_48279.method_56433(class_9135::method_56382), PiercingWeapon::hitSound, PiercingWeapon::new);

    public void playSound(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 p = (class_1657)entity;
            this.sound.ifPresent(sound -> entity.method_5770().method_60511(p, entity.method_23317(), entity.method_23318(), entity.method_23321(), sound, entity.method_5634(), 1.0f, 1.0f));
        }
    }

    public void playHitSound(class_1297 entity) {
        this.hitSound.ifPresent(sound -> entity.method_5770().method_60511(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), sound, entity.method_5634(), 1.0f, 1.0f));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canHit(class_1297 attacker, class_1297 target) {
        if (!target.method_49108()) return false;
        if (target.method_5655()) return false;
        if (!target.method_5805()) return false;
        if (target instanceof class_1657) {
            class_1657 playerEntity = (class_1657)target;
            if (attacker instanceof class_1657) {
                class_1657 playerEntity2 = (class_1657)attacker;
                if (!playerEntity2.method_7256(playerEntity)) return false;
            }
        }
        if (attacker.method_5794(target)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean stab(class_1309 attacker, class_1304 slot) {
        class_1937 entityHitResult2222;
        class_1799 stack;
        float f = (float)attacker.method_45325(class_5134.field_23721);
        boolean bl = false;
        float minReach = 0.0f;
        float maxReach = 3.0f;
        Object object = attacker.method_6118(slot).method_57824(Spears.ATTACK_RANGE);
        if (object instanceof AttackRange) {
            AttackRange attackRange = (AttackRange)object;
            try {
                float f2;
                float reachMin = f2 = attackRange.minReach();
                float reachMax = f2 = attackRange.maxReach();
                minReach = reachMin;
                maxReach = reachMax;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (attacker instanceof SpearUser) {
            SpearUser s = (SpearUser)attacker;
            for (class_3966 entityHitResult2222 : Spears.collectPiercingCollisions(attacker, minReach, maxReach, this.hitboxMargin, entity -> PiercingWeapon.canHit((class_1297)attacker, entity))) {
                bl |= s.pierce(slot, entityHitResult2222.method_17782(), f, true, this.dealsKnockback, this.dismounts);
            }
        }
        if (!(stack = attacker.method_6118(slot)).method_7960() && (entityHitResult2222 = attacker.method_37908()) instanceof class_3218) {
            class_3218 server = (class_3218)entityHitResult2222;
            class_9304 itemEnchantmentsComponent = (class_9304)stack.method_57824(class_9334.field_49633);
            if (itemEnchantmentsComponent != null && !itemEnchantmentsComponent.method_57543()) {
                class_9699 enchantmentEffectContext = new class_9699(stack, slot, attacker);
                for (Object2IntMap.Entry entry : itemEnchantmentsComponent.method_57539()) {
                    class_6880 registryEntry = (class_6880)entry.getKey();
                    int lvl = class_1890.method_8225((class_6880)registryEntry, (class_1799)stack);
                    if (!((class_1887)registryEntry.comp_349()).method_60026(slot)) continue;
                    for (class_9698 enchantmentEffectEntry : ((class_1887)registryEntry.comp_349()).method_60034(Spears.POST_PIERCING_ATTACK)) {
                        class_8567 lootContextParameterSet;
                        if (!enchantmentEffectEntry.method_60006(new class_47.class_48(lootContextParameterSet = new class_8567.class_8568(server).method_51874(class_181.field_1226, (Object)attacker).method_51874(class_181.field_51805, (Object)lvl).method_51874(class_181.field_24424, (Object)attacker.method_19538()).method_51875(class_173.field_51804)).method_309(Optional.empty()))) continue;
                        ((class_9721)enchantmentEffectEntry.comp_2680()).method_60220(server, lvl, enchantmentEffectContext, (class_1297)attacker, attacker.method_19538());
                    }
                }
            }
        }
        if (bl) {
            this.playHitSound((class_1297)attacker);
        }
        this.playSound((class_1297)attacker);
        attacker.method_23667(class_1268.field_5808, false);
        return bl;
    }
}

