/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.fabric;

import com.notunanancyowen.Spears;
import com.notunanancyowen.components.PiercingWeapon;
import com.notunanancyowen.packets.PlayerStabC2SPacket;
import com.notunanancyowen.packets.TriggerStabEffectsC2SPacket;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7706;

public final class SpearsFabric
implements ModInitializer {
    private static HashMap<String, Boolean> makeConfig() {
        HashMap<String, Boolean> toggles = Spears.makeConfig();
        try {
            File config = FabricLoader.getInstance().getConfigDir().resolve("spears-common.toml").toFile();
            if (config.createNewFile()) {
                try (FileWriter configWriter = new FileWriter(config);){
                    configWriter.write("#Whether spears have a charge attack\nspear_charge_attacks = true\n#Whether spears have a stabbing animation\nspear_stabbing_animation = true\n#Whether tridents attack like spears\ntridents_use_spear_attack_animation = false");
                }
            }
            try (FileReader configReader = new FileReader(config);){
                String configText;
                BufferedReader reader = new BufferedReader(configReader);
                StringBuilder bob = new StringBuilder();
                while ((configText = reader.readLine()) != null) {
                    bob.append(configText);
                    bob.append(System.lineSeparator());
                }
                bob.deleteCharAt(bob.length() - 1);
                reader.close();
                bob.toString().lines().forEach(configContent -> {
                    if (!configContent.startsWith("#")) {
                        String[] configValues = configContent.replace(" ", "").split("=", 2);
                        toggles.putIfAbsent(configValues[0], configValues[1].contains("true"));
                    }
                });
            }
        }
        catch (IOException | SecurityException e) {
            Spears.LOGGER.info("Error making config: %n" + e.getLocalizedMessage());
        }
        return toggles;
    }

    public void onInitialize() {
        Spears.config = SpearsFabric.makeConfig();
        Spears.hasBetterCombat = FabricLoader.getInstance().isModLoaded("bettercombat");
        PayloadTypeRegistry.playC2S().register(PlayerStabC2SPacket.ID, PlayerStabC2SPacket.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(TriggerStabEffectsC2SPacket.ID, TriggerStabEffectsC2SPacket.PACKET_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(PlayerStabC2SPacket.ID, (packet, context) -> {
            class_1297 p = packet.getEntity(context.player().method_37908());
            if (p instanceof class_3222) {
                class_3222 sp = (class_3222)p;
                Object patt0$temp = sp.method_6047().method_57824(Spears.PIERCING_WEAPON);
                if (patt0$temp instanceof PiercingWeapon) {
                    PiercingWeapon pw = (PiercingWeapon)patt0$temp;
                    pw.stab((class_1309)sp, class_1304.field_6173);
                }
                sp.method_7350();
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(TriggerStabEffectsC2SPacket.ID, (packet, context) -> {
            if (packet.toggle()) {
                packet.trigger(context.player());
            }
        });
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40202).register(itemGroup -> {
            itemGroup.addAfter((class_1935)class_1802.field_22022, new class_1935[]{Spears.WOODEN_SPEAR});
            itemGroup.addAfter((class_1935)Spears.WOODEN_SPEAR, new class_1935[]{Spears.STONE_SPEAR});
            itemGroup.addAfter((class_1935)Spears.STONE_SPEAR, new class_1935[]{Spears.IRON_SPEAR});
            itemGroup.addAfter((class_1935)Spears.IRON_SPEAR, new class_1935[]{Spears.GOLDEN_SPEAR});
            itemGroup.addAfter((class_1935)Spears.GOLDEN_SPEAR, new class_1935[]{Spears.DIAMOND_SPEAR});
            itemGroup.addAfter((class_1935)Spears.DIAMOND_SPEAR, new class_1935[]{Spears.NETHERITE_SPEAR});
        });
        Spears.init();
    }
}

