/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.spears.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.notunanancyowen.Spears;
import com.notunanancyowen.components.KineticWeapon;
import com.notunanancyowen.components.SwingAnimation;
import com.notunanancyowen.components.UseEffects;
import com.notunanancyowen.dataholders.SpearUser;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1508;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3483;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9109;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
implements SpearUser {
    @Unique
    private long spears$lastKineticAttackTime = Integer.MIN_VALUE;
    @Unique
    @Nullable
    private Object2LongMap<class_1297> spears$piercingCooldowns;

    @Shadow
    public abstract class_1799 method_6047();

    @Shadow
    public abstract boolean method_6059(class_6880<class_1291> var1);

    @Shadow
    @Nullable
    public abstract class_1293 method_6112(class_6880<class_1291> var1);

    @Shadow
    public abstract class_1799 method_6030();

    @Inject(method={"getHandSwingDuration"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideSwingDurationForSpear(CallbackInfoReturnable<Integer> cir) {
        Object object = this.method_6047().method_57824(Spears.SWING_ANIMATION);
        if (object instanceof SwingAnimation) {
            SwingAnimation s = (SwingAnimation)object;
            class_1309 me = (class_1309)this;
            int swing = s.swingTicks();
            if (class_1292.method_5576((class_1309)me)) {
                cir.setReturnValue((Object)(swing - (1 + class_1292.method_5575((class_1309)me))));
            } else {
                cir.setReturnValue((Object)(this.method_6059((class_6880<class_1291>)class_1294.field_5901) ? swing + (1 + Objects.requireNonNull(this.method_6112((class_6880<class_1291>)class_1294.field_5901)).method_5578()) * 2 : swing));
            }
        }
    }

    @Inject(method={"setCurrentHand"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;emitGameEvent(Lnet/minecraft/registry/entry/RegistryEntry;)V")})
    private void recordPiercingCooldowns(class_1268 hand, CallbackInfo ci) {
        Object object = this.method_6030().method_57824(Spears.KINETIC_WEAPON);
        if (object instanceof KineticWeapon) {
            KineticWeapon k = (KineticWeapon)object;
            this.spears$piercingCooldowns = new Object2LongOpenHashMap();
            k.playSound((class_1297)((class_1309)this));
        }
    }

    @WrapOperation(method={"setCurrentHand"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;emitGameEvent(Lnet/minecraft/registry/entry/RegistryEntry;)V")})
    private void suppressSoundOnStart(class_1309 instance, class_6880<class_5712> registryEntry, Operation<Void> original) {
        UseEffects u;
        Object object = instance.method_6030().method_57824(Spears.USE_EFFECTS);
        if (object instanceof UseEffects && !(u = (UseEffects)object).interactVibrations()) {
            return;
        }
        original.call(new Object[]{instance, registryEntry});
    }

    @WrapOperation(method={"clearActiveItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;emitGameEvent(Lnet/minecraft/registry/entry/RegistryEntry;)V")})
    private void suppressSoundOnStop(class_1309 instance, class_6880<class_5712> registryEntry, Operation<Void> original) {
        UseEffects u;
        Object object = instance.method_6030().method_57824(Spears.USE_EFFECTS);
        if (object instanceof UseEffects && !(u = (UseEffects)object).interactVibrations()) {
            return;
        }
        original.call(new Object[]{instance, registryEntry});
    }

    @Inject(method={"clearActiveItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setLivingFlag(IZ)V")})
    private void forgetPiercingCooldowns(CallbackInfo ci) {
        this.spears$piercingCooldowns = null;
    }

    @Inject(method={"handleStatus"}, at={@At(value="HEAD")})
    private void handleKineticAttack(byte status, CallbackInfo ci) {
        if (status == 2) {
            this.spears$lastKineticAttackTime = ((class_1309)this).method_5770().method_8510();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tickPiercingCooldowns(CallbackInfo ci) {
        if (!((class_1309)this).method_5770().method_8608() && this.spears$piercingCooldowns != null) {
            for (class_1297 e : this.spears$piercingCooldowns.keySet()) {
                long l = this.spears$piercingCooldowns.getLong((Object)e);
                if (l > 1L) {
                    this.spears$piercingCooldowns.replace((Object)e, l - 1L);
                    continue;
                }
                this.spears$piercingCooldowns.remove((Object)e, l);
            }
        }
    }

    @Override
    public float getTimeSinceLastKineticAttack(float tickProgress) {
        class_1309 me = (class_1309)this;
        return this.spears$lastKineticAttackTime < 0L ? 0.0f : (float)(me.method_5770().method_8510() - this.spears$lastKineticAttackTime) + tickProgress;
    }

    @Override
    public boolean isInPiercingCooldown(class_1297 target, int cooldownTicks) {
        if (this.spears$piercingCooldowns == null) {
            return false;
        }
        class_1309 me = (class_1309)this;
        return this.spears$piercingCooldowns.containsKey((Object)target) ? me.method_5770().method_8510() - this.spears$piercingCooldowns.getLong((Object)target) < (long)cooldownTicks : false;
    }

    @Override
    public void startPiercingCooldown(class_1297 target) {
        if (this.spears$piercingCooldowns != null) {
            class_1309 me = (class_1309)this;
            this.spears$piercingCooldowns.put((Object)target, me.method_5770().method_8510());
        }
    }

    @Override
    public int countSpearedMobs() {
        return this.spears$piercingCooldowns == null ? 0 : this.spears$piercingCooldowns.size();
    }

    @Override
    public boolean pierce(class_1304 slot, class_1297 target, float damage, boolean dealDamage, boolean knockback, boolean dismount) {
        class_1799 itemStack;
        class_1309 attacker = (class_1309)this;
        class_1937 class_19372 = attacker.method_5770();
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (attacker instanceof class_1657) {
            class_1309 livingEntity;
            boolean bl;
            class_1676 projectileEntity;
            class_1657 player = (class_1657)attacker;
            itemStack = attacker.method_6118(slot);
            class_1282 damageSource = attacker.method_48923().method_48802(player);
            float halfCD = player.method_7261(0.5f);
            float f = halfCD * (class_1890.method_60120((class_3218)serverWorld, (class_1799)player.method_59958(), (class_1297)target, (class_1282)damageSource, (float)damage) - damage);
            damage *= 0.2f + halfCD * halfCD * 0.8f;
            if (knockback && target.method_5864().method_20210(class_3483.field_51503) && target instanceof class_1676 && (projectileEntity = (class_1676)target).method_59859(class_9109.field_51509, (class_1297)attacker, (class_1297)attacker, true)) {
                return true;
            }
            float g = dealDamage ? damage + f : 0.0f;
            float h = 0.0f;
            if (target instanceof class_1309) {
                class_1309 livingEntity2 = (class_1309)target;
                h = livingEntity2.method_6032();
            }
            boolean bl2 = bl = dealDamage && target.method_5643(damageSource, g);
            if (knockback && target instanceof class_1309) {
                class_1309 knockable = (class_1309)target;
                knockable.method_6005((double)0.4f, attacker.method_23317() - target.method_23317(), attacker.method_23321() - target.method_23321());
            }
            boolean bl22 = false;
            if (dismount && target.method_5765()) {
                bl22 = true;
                target.method_5848();
            }
            if (!(bl || knockback || bl22)) {
                return false;
            }
            if (class_1890.method_60120((class_3218)serverWorld, (class_1799)itemStack, (class_1297)target, (class_1282)damageSource, (float)f) > f) {
                player.method_7304(target);
            }
            player.method_6114(target);
            class_1297 entity = target;
            if (target instanceof class_1508) {
                entity = ((class_1508)target).field_7007;
            }
            boolean runEnchantmentEffects = bl;
            bl = false;
            if (entity instanceof class_1309) {
                livingEntity = (class_1309)entity;
                bl = itemStack.method_7979(livingEntity, player);
            }
            if (runEnchantmentEffects) {
                class_1890.method_60619((class_3218)serverWorld, (class_1297)target, (class_1282)damageSource, (class_1799)itemStack);
            }
            if (!player.method_5770().method_8608() && !itemStack.method_7960() && entity instanceof class_1309) {
                livingEntity = (class_1309)entity;
                if (bl) {
                    itemStack.method_59979(livingEntity, player);
                }
                if (itemStack.method_7960()) {
                    if (itemStack == player.method_6047()) {
                        player.method_6122(class_1268.field_5808, class_1799.field_8037);
                    } else {
                        player.method_6122(class_1268.field_5810, class_1799.field_8037);
                    }
                }
            }
            if (target instanceof class_1309) {
                f = h - ((class_1309)target).method_6032();
                player.method_7339(class_3468.field_15399, Math.round(f * 10.0f));
                if (player.method_5770() instanceof class_3218 && f > 2.0f) {
                    int i = (int)((double)f * 0.5);
                    serverWorld.method_14199((class_2394)class_2398.field_11209, target.method_23317(), target.method_23323(0.5), target.method_23321(), i, 0.1, 0.0, 0.1, 0.2);
                }
            }
            player.method_7322(0.1f);
            return true;
        }
        itemStack = attacker.method_6118(slot);
        class_1282 damageSource = attacker.method_48923().method_48812(attacker);
        float f = class_1890.method_60120((class_3218)serverWorld, (class_1799)itemStack, (class_1297)target, (class_1282)damageSource, (float)damage);
        boolean bl2 = dealDamage && target.method_5643(damageSource, f);
        boolean bl = knockback | bl2;
        if (knockback && target instanceof class_1309) {
            class_1309 knockable = (class_1309)target;
            knockable.method_6005((double)0.4f, attacker.method_23317() - target.method_23317(), attacker.method_23321() - target.method_23321());
        }
        if (dismount && target.method_5765()) {
            bl = true;
            target.method_5848();
        }
        if (bl2) {
            class_1890.method_60107((class_3218)serverWorld, (class_1297)target, (class_1282)damageSource);
        }
        if (!bl) {
            return false;
        }
        if (attacker instanceof class_1309) {
            class_1309 livingEntity = attacker;
            livingEntity.method_6114(target);
        }
        return true;
    }
}

