/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.notunanancyowen.components.AttackRange;
import com.notunanancyowen.components.KineticWeapon;
import com.notunanancyowen.components.PiercingWeapon;
import com.notunanancyowen.components.SwingAnimation;
import com.notunanancyowen.components.UseEffects;
import com.notunanancyowen.criteria.SpearedMobs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Spears {
    public static final String MOD_ID = "spears";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"spears");
    public static final DataComponentType<UseEffects> USE_EFFECTS = Spears.register("use_effects", builder -> builder.persistent(UseEffects.CODEC).networkSynchronized(UseEffects.PACKET_CODEC));
    public static final DataComponentType<AttackRange> ATTACK_RANGE = Spears.register("attack_range", builder -> builder.persistent(AttackRange.CODEC).networkSynchronized(AttackRange.PACKET_CODEC));
    public static final DataComponentType<KineticWeapon> KINETIC_WEAPON = Spears.register("kinetic_weapon", builder -> builder.persistent(KineticWeapon.CODEC).networkSynchronized(KineticWeapon.PACKET_CODEC));
    public static final DataComponentType<SwingAnimation> SWING_ANIMATION = Spears.register("swing_animation", builder -> builder.persistent(SwingAnimation.CODEC).networkSynchronized(SwingAnimation.PACKET_CODEC));
    public static final DataComponentType<PiercingWeapon> PIERCING_WEAPON = Spears.register("piercing_weapon", builder -> builder.persistent(PiercingWeapon.CODEC).networkSynchronized(PiercingWeapon.PACKET_CODEC));
    public static final DataComponentType<Float> MINIMUM_ATTACK_CHARGE = Spears.register("minimum_attack_charge", builder -> builder.persistent(Spears.rangedInclusiveFloat(0.0f, 1.0f)).networkSynchronized(ByteBufCodecs.FLOAT));
    public static final Holder<SoundEvent> SPEAR_ATTACK = Spears.registerSound("item.spear.attack");
    public static final Holder<SoundEvent> SPEAR_HIT = Spears.registerSound("item.spear.hit");
    public static final Holder<SoundEvent> SPEAR_USE = Spears.registerSound("item.spear.use");
    public static final Holder<SoundEvent> SPEAR_WOOD_ATTACK = Spears.registerSound("item.spear_wood.attack");
    public static final Holder<SoundEvent> SPEAR_WOOD_HIT = Spears.registerSound("item.spear_wood.hit");
    public static final Holder<SoundEvent> SPEAR_WOOD_USE = Spears.registerSound("item.spear_wood.use");
    public static final Holder<SoundEvent> SPEAR_LUNGE = Spears.registerSound("item.spear.lunge");
    public static final TagKey<Item> SPEARS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"spears"));
    public static final Item WOODEN_SPEAR = Spears.registerSpear("wooden_spear", (Tier)Tiers.WOOD, 0.65f, 0.7f, 0.75f, 5.0f, 14.0f, 6.0f, 5.1f, 15.0f, 4.6f);
    public static final Item STONE_SPEAR = Spears.registerSpear("stone_spear", (Tier)Tiers.STONE, 0.75f, 0.82f, 0.7f, 4.5f, 10.0f, 5.5f, 5.1f, 13.75f, 4.6f);
    public static final Item GOLDEN_SPEAR = Spears.registerSpear("golden_spear", (Tier)Tiers.GOLD, 0.95f, 0.7f, 0.7f, 3.5f, 10.0f, 5.5f, 5.1f, 13.75f, 4.6f);
    public static final Item IRON_SPEAR = Spears.registerSpear("iron_spear", (Tier)Tiers.IRON, 0.95f, 0.95f, 0.6f, 2.5f, 8.0f, 4.5f, 5.1f, 11.25f, 4.6f);
    public static final Item DIAMOND_SPEAR = Spears.registerSpear("diamond_spear", (Tier)Tiers.DIAMOND, 1.05f, 1.075f, 0.5f, 3.0f, 7.5f, 4.0f, 5.1f, 10.0f, 4.6f);
    public static final Item NETHERITE_SPEAR = Spears.registerSpear("netherite_spear", (Tier)Tiers.NETHERITE, 1.15f, 1.2f, 0.4f, 2.5f, 7.0f, 3.5f, 5.1f, 8.75f, 4.6f);
    public static DataComponentType<List<ConditionalEffect<EnchantmentEntityEffect>>> POST_PIERCING_ATTACK = Spears.registerEffect("post_piercing_attack", builder -> builder.persistent(ConditionalEffect.codec((Codec)EnchantmentEntityEffect.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_DAMAGE).listOf()));
    public static final SpearedMobs SPEARED_MOBS = Spears.registerCriterion("spear_mobs", new SpearedMobs());
    public static HashMap<String, Boolean> config;
    public static boolean hasBetterCombat;

    public static Collection<EntityHitResult> collectPiercingCollisions(LivingEntity entity, float minReach, float maxReach, float hitboxMargin, Predicate<Entity> hitPredicate) {
        Vec3 vec3d = entity.calculateViewVector(entity.getXRot(), entity.getYHeadRot());
        Vec3 vec3d2 = entity.getEyePosition();
        Vec3 vec3d3 = vec3d2.add(vec3d.scale((double)minReach));
        double d = entity.getKnownMovement().dot(vec3d);
        Vec3 vec3d4 = vec3d2.add(vec3d.scale((double)maxReach + Math.max(0.0, d)));
        return (Collection)Spears.collectPiercingCollisions((Entity)entity, vec3d2, vec3d3, hitPredicate, vec3d4, hitboxMargin, ClipContext.Block.COLLIDER).map(hitResult -> List.of(), hitResults -> hitResults);
    }

    private static Either<BlockHitResult, Collection<EntityHitResult>> collectPiercingCollisions(Entity entity, Vec3 pos, Vec3 minReach, Predicate<Entity> hitPredicate, Vec3 maxReach, float hitboxMargin, ClipContext.Block shapeType) {
        Level world = entity.getCommandSenderWorld();
        BlockHitResult blockHitResult = Spears.getCollisionsIncludingWorldBorder(world, new ClipContext(pos, maxReach, shapeType, ClipContext.Fluid.NONE, entity));
        if (blockHitResult.getType() != HitResult.Type.MISS && pos.distanceToSqr(maxReach = blockHitResult.getLocation()) < pos.distanceToSqr(minReach)) {
            return Either.left((Object)blockHitResult);
        }
        AABB box = AABB.ofSize((Vec3)minReach, (double)hitboxMargin, (double)hitboxMargin, (double)hitboxMargin).expandTowards(maxReach.subtract(minReach)).inflate(1.0);
        Collection<EntityHitResult> collection = Spears.collectPiercingCollisions(world, entity, minReach, maxReach, box, hitPredicate, hitboxMargin, shapeType, true);
        return !collection.isEmpty() ? Either.right(collection) : Either.left((Object)blockHitResult);
    }

    public static Collection<EntityHitResult> collectPiercingCollisions(Level world, Entity entity, Vec3 from, Vec3 to, AABB box, Predicate<Entity> hitPredicate, float hitboxMargin, ClipContext.Block shapeType, boolean bl) {
        ArrayList<EntityHitResult> list = new ArrayList<EntityHitResult>();
        for (Entity entity2 : world.getEntities(entity, box, hitPredicate)) {
            Vec3 vec3d2;
            Optional optional2;
            AABB box2 = entity2.getBoundingBox();
            if (bl && box2.contains(from)) {
                list.add(new EntityHitResult(entity2, from));
                continue;
            }
            Optional optional = box2.clip(from, to);
            if (optional.isPresent()) {
                list.add(new EntityHitResult(entity2, (Vec3)optional.get()));
                continue;
            }
            if ((double)hitboxMargin <= 0.0 || !(optional2 = box2.inflate((double)hitboxMargin).clip(from, to)).isPresent()) continue;
            Vec3 vec3d = (Vec3)optional2.get();
            BlockHitResult blockHitResult = Spears.getCollisionsIncludingWorldBorder(world, new ClipContext(vec3d, vec3d2 = box2.getCenter(), shapeType, ClipContext.Fluid.NONE, entity));
            if (blockHitResult.getType() != HitResult.Type.MISS) {
                vec3d2 = blockHitResult.getLocation();
            }
            Optional optional3 = entity2.getBoundingBox().clip(vec3d, vec3d2);
            optional3.ifPresent(d -> list.add(new EntityHitResult(entity2, d)));
        }
        return list;
    }

    private static BlockHitResult getCollisionsIncludingWorldBorder(Level world, ClipContext context) {
        BlockHitResult blockHitResult = world.clip(context);
        WorldBorder worldBorder = world.getWorldBorder();
        if (worldBorder.isWithinBounds(context.getFrom()) && !worldBorder.isWithinBounds(blockHitResult.getLocation())) {
            Vec3 vec3d = blockHitResult.getLocation().subtract(context.getFrom());
            Direction direction = Direction.getNearest((double)vec3d.x, (double)vec3d.y, (double)vec3d.z);
            Vec3 vec3d2 = blockHitResult.getLocation();
            vec3d2 = new Vec3(Mth.clamp((double)vec3d2.x, (double)worldBorder.getMinX(), (double)(worldBorder.getMaxX() - (double)1.0E-5f)), vec3d2.y, Mth.clamp((double)vec3d2.z, (double)worldBorder.getMinZ(), (double)(worldBorder.getMaxZ() - (double)1.0E-5f)));
            return new BlockHitResult(vec3d2, direction, BlockPos.containing((Position)vec3d2), false);
        }
        return blockHitResult;
    }

    public static Codec<Float> rangedInclusiveFloat(float minInclusive, float maxInclusive, Function<Float, String> messageFactory) {
        return Codec.FLOAT.validate(value -> value.compareTo(Float.valueOf(minInclusive)) >= 0 && value.compareTo(Float.valueOf(maxInclusive)) <= 0 ? DataResult.success((Object)value) : DataResult.error(() -> (String)messageFactory.apply((Float)value)));
    }

    public static Codec<Float> rangedInclusiveFloat(float minInclusive, float maxInclusive) {
        return Spears.rangedInclusiveFloat(minInclusive, maxInclusive, value -> "Value must be within range [" + minInclusive + ";" + maxInclusive + "]: " + value);
    }

    public static <T> DataComponentType<T> register(String id, UnaryOperator<DataComponentType.Builder<T>> builderOperator) {
        return (DataComponentType)Registry.register((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)id, (Object)((DataComponentType.Builder)builderOperator.apply(DataComponentType.builder())).build());
    }

    private static Holder<SoundEvent> registerSound(String id) {
        ResourceLocation identifier = ResourceLocation.withDefaultNamespace((String)id);
        return Registry.registerForHolder((Registry)BuiltInRegistries.SOUND_EVENT, (ResourceLocation)identifier, (Object)SoundEvent.createVariableRangeEvent((ResourceLocation)identifier));
    }

    public static Item registerSpear(String id, Tier material, float swingAnimationSeconds, float chargeDamageMultiplier, float chargeDelaySeconds, float maxDurationForDismountSeconds, float minSpeedForDismount, float maxDurationForChargeKnockbackInSeconds, float minSpeedForChargeKnockback, float maxDurationForChargeDamageInSeconds, float minRelativeSpeedForChargeDamage) {
        boolean wood = material == Tiers.WOOD;
        Item.Properties components = new Item.Properties().component(USE_EFFECTS, (Object)new UseEffects(1.0f, true, false)).attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)material.getAttackDamageBonus(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)(1.0f / swingAnimationSeconds) - 4.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()).component(MINIMUM_ATTACK_CHARGE, (Object)Float.valueOf(1.0f)).component(ATTACK_RANGE, (Object)new AttackRange(2.0f, 4.5f));
        HashMap<String, Boolean> config = Spears.makeConfig();
        boolean chargeAttacksEnabled = config.getOrDefault("spear_charge_attacks", true);
        if (config.getOrDefault("spear_stabbing_animation", true).booleanValue()) {
            components.component(SWING_ANIMATION, (Object)new SwingAnimation((int)(swingAnimationSeconds * 20.0f), "stab")).component(PIERCING_WEAPON, (Object)new PiercingWeapon(0.25f, true, false, Optional.of(wood ? SPEAR_WOOD_ATTACK : SPEAR_ATTACK), Optional.of(wood ? SPEAR_WOOD_HIT : SPEAR_HIT)));
        }
        if (chargeAttacksEnabled) {
            components.component(KINETIC_WEAPON, (Object)new KineticWeapon(0.125f, 10, (int)(chargeDelaySeconds * 20.0f), KineticWeapon.Condition.ofMinSpeed((int)(maxDurationForDismountSeconds * 20.0f), minSpeedForDismount), KineticWeapon.Condition.ofMinSpeed((int)(maxDurationForChargeKnockbackInSeconds * 20.0f), minSpeedForChargeKnockback), KineticWeapon.Condition.ofMinRelativeSpeed((int)(maxDurationForChargeDamageInSeconds * 20.0f), minRelativeSpeedForChargeDamage), 0.38f, chargeDamageMultiplier, Optional.of(wood ? SPEAR_WOOD_USE : SPEAR_USE), Optional.of(wood ? SPEAR_WOOD_HIT : SPEAR_HIT)));
        }
        if (material == Tiers.NETHERITE) {
            components.fireResistant();
        }
        if (chargeAttacksEnabled) {
            return (Item)Registry.register((Registry)BuiltInRegistries.ITEM, (String)id, (Object)new TieredItem(material, components){

                public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
                    if (selected) {
                        stack.setEntityRepresentation(entity);
                    } else {
                        stack.setEntityRepresentation(null);
                    }
                    super.inventoryTick(stack, world, entity, slot, selected);
                }

                public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player miner) {
                    return !miner.isCreative();
                }

                public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
                    return true;
                }

                public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
                    stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
                }

                public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
                    user.startUsingItem(hand);
                    return InteractionResultHolder.consume((Object)user.getItemInHand(hand));
                }

                public int getUseDuration(ItemStack stack, LivingEntity user) {
                    return 72000;
                }
            });
        }
        return (Item)Registry.register((Registry)BuiltInRegistries.ITEM, (String)id, (Object)new TieredItem(material, components){

            public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
                if (selected) {
                    stack.setEntityRepresentation(entity);
                } else {
                    stack.setEntityRepresentation(null);
                }
                super.inventoryTick(stack, world, entity, slot, selected);
            }

            public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player miner) {
                return !miner.isCreative();
            }

            public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
                return true;
            }

            public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
                stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
            }
        });
    }

    private static <T> DataComponentType<T> registerEffect(String id, UnaryOperator<DataComponentType.Builder<T>> builderOperator) {
        return (DataComponentType)Registry.register((Registry)BuiltInRegistries.ENCHANTMENT_EFFECT_COMPONENT_TYPE, (String)id, (Object)((DataComponentType.Builder)builderOperator.apply(DataComponentType.builder())).build());
    }

    private static <T extends CriterionTrigger<?>> T registerCriterion(String id, T criterion) {
        return (T)((CriterionTrigger)Registry.register((Registry)BuiltInRegistries.TRIGGER_TYPES, (String)id, criterion));
    }

    public static HashMap<String, Boolean> makeConfig() {
        if (config == null) {
            config = new HashMap();
        }
        return config;
    }

    public static Item TridentRegister() {
        Item.Properties components = new Item.Properties().rarity(Rarity.EPIC).durability(250).attributes(TridentItem.createAttributes()).component(DataComponents.TOOL, (Object)TridentItem.createToolProperties());
        if (Spears.makeConfig().getOrDefault("tridents_use_spear_attack_animation", false).booleanValue()) {
            components.component(PIERCING_WEAPON, (Object)new PiercingWeapon(0.2f, true, false, Optional.of(SoundEvents.TRIDENT_THROW), Optional.empty())).component(SWING_ANIMATION, (Object)new SwingAnimation(20, "stab")).component(MINIMUM_ATTACK_CHARGE, (Object)Float.valueOf(0.9f)).component(ATTACK_RANGE, (Object)new AttackRange(0.0f, 4.0f));
        }
        return Items.registerItem((String)"trident", (Item)new TridentItem(components));
    }

    public static void init() {
        LOGGER.info("Backported spears!");
    }

    static {
        hasBetterCombat = false;
    }
}

