/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.notunanancyowen.PacketCodecHelper;
import com.notunanancyowen.Spears;
import com.notunanancyowen.components.AttackRange;
import com.notunanancyowen.components.PiercingWeapon;
import com.notunanancyowen.dataholders.SpearUser;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public record KineticWeapon(float hitboxMargin, int contactCooldownTicks, int delayTicks, Optional<Condition> dismountConditions, Optional<Condition> knockbackConditions, Optional<Condition> damageConditions, float forwardMovement, float damageMultiplier, Optional<Holder<SoundEvent>> sound, Optional<Holder<SoundEvent>> hitSound) {
    public static final Codec<KineticWeapon> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Spears.rangedInclusiveFloat(0.0f, 1.0f).optionalFieldOf("hitbox_margin", (Object)Float.valueOf(0.3f)).forGetter(KineticWeapon::hitboxMargin), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("contact_cooldown_ticks", (Object)10).forGetter(KineticWeapon::contactCooldownTicks), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("delay_ticks", (Object)0).forGetter(KineticWeapon::delayTicks), (App)Condition.CODEC.optionalFieldOf("dismount_conditions").forGetter(KineticWeapon::dismountConditions), (App)Condition.CODEC.optionalFieldOf("knockback_conditions").forGetter(KineticWeapon::knockbackConditions), (App)Condition.CODEC.optionalFieldOf("damage_conditions").forGetter(KineticWeapon::damageConditions), (App)Codec.FLOAT.optionalFieldOf("forward_movement", (Object)Float.valueOf(0.0f)).forGetter(KineticWeapon::forwardMovement), (App)Codec.FLOAT.optionalFieldOf("damage_multiplier", (Object)Float.valueOf(1.0f)).forGetter(KineticWeapon::damageMultiplier), (App)SoundEvent.CODEC.optionalFieldOf("sound").forGetter(KineticWeapon::sound), (App)SoundEvent.CODEC.optionalFieldOf("hit_sound").forGetter(KineticWeapon::hitSound)).apply((Applicative)instance, KineticWeapon::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, KineticWeapon> PACKET_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.FLOAT, KineticWeapon::hitboxMargin, ByteBufCodecs.VAR_INT, KineticWeapon::contactCooldownTicks, ByteBufCodecs.VAR_INT, KineticWeapon::delayTicks, Condition.PACKET_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::dismountConditions, Condition.PACKET_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::knockbackConditions, Condition.PACKET_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::damageConditions, ByteBufCodecs.FLOAT, KineticWeapon::forwardMovement, ByteBufCodecs.FLOAT, KineticWeapon::damageMultiplier, SoundEvent.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::sound, SoundEvent.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::hitSound, KineticWeapon::new);

    public static Vec3 getAmplifiedMovement(Entity entity) {
        Vec3 vec3;
        if (!(entity instanceof Player) && entity.isPassenger()) {
            entity = entity.getRootVehicle();
        }
        if (entity instanceof Player) {
            Player p = (Player)entity;
            vec3 = p.getKnownMovement();
        } else {
            vec3 = entity.position().subtract(entity.xo, entity.yo, entity.zo);
        }
        return vec3.scale(20.0);
    }

    public void playSound(Entity entity) {
        if (entity instanceof Player) {
            Player p = (Player)entity;
            this.sound.ifPresent(sound -> entity.getCommandSenderWorld().playSound(p, entity.getX(), entity.getY(), entity.getZ(), sound, entity.getSoundSource(), 1.0f, 1.0f));
        }
    }

    public void playHitSound(Entity entity) {
        this.hitSound.ifPresent(sound -> entity.getCommandSenderWorld().playSound(null, entity.getX(), entity.getY(), entity.getZ(), sound, entity.getSoundSource(), 1.0f, 1.0f));
    }

    public int getUseTicks() {
        return this.delayTicks + this.damageConditions.map(Condition::maxDurationTicks).orElse(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void usageTick(ItemStack stack, int remainingUseTicks, LivingEntity user, EquipmentSlot slot) {
        Object attackRange;
        int i = stack.getUseDuration(user) - remainingUseTicks;
        if (i < this.delayTicks) return;
        if (!(user instanceof SpearUser)) return;
        SpearUser s = (SpearUser)user;
        i -= this.delayTicks;
        Vec3 vec3d = user.getLookAngle();
        double d = vec3d.dot(KineticWeapon.getAmplifiedMovement((Entity)user));
        float f = user instanceof Player ? 1.0f : 0.2f;
        float g = user instanceof Player ? 1.0f : 0.5f;
        double e = user.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
        boolean bl = false;
        float minReach = 0.0f;
        float maxReach = 3.0f;
        Object object = stack.get(Spears.ATTACK_RANGE);
        if (object instanceof AttackRange) {
            attackRange = (AttackRange)object;
            try {
                float f2;
                float reachMin = f2 = ((AttackRange)attackRange).minReach();
                float reachMax = f2 = ((AttackRange)attackRange).maxReach();
                minReach = reachMin;
                maxReach = reachMax;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        attackRange = Spears.collectPiercingCollisions(user, g * minReach, g * maxReach, this.hitboxMargin, target -> PiercingWeapon.canHit((Entity)user, target)).iterator();
        while (true) {
            boolean bl5;
            if (!attackRange.hasNext()) {
                if (!bl) return;
                this.playHitSound((Entity)user);
                user.getCommandSenderWorld().broadcastEntityEvent((Entity)user, (byte)2);
                if (!(user instanceof ServerPlayer)) return;
                ServerPlayer serverPlayerEntity = (ServerPlayer)user;
                Spears.SPEARED_MOBS.spearMob(serverPlayerEntity, s.countSpearedMobs());
                return;
            }
            EntityHitResult entityHitResult = (EntityHitResult)attackRange.next();
            Entity entity = entityHitResult.getEntity();
            boolean bl2 = s.isInPiercingCooldown(entity, this.contactCooldownTicks);
            s.startPiercingCooldown(entity);
            if (bl2) continue;
            double j = Math.max(0.0, d - vec3d.dot(KineticWeapon.getAmplifiedMovement(entity)));
            boolean bl3 = this.dismountConditions.isPresent() && this.dismountConditions.get().isSatisfied(i, d, j, f);
            boolean bl4 = this.knockbackConditions.isPresent() && this.knockbackConditions.get().isSatisfied(i, d, j, f);
            boolean bl6 = bl5 = this.damageConditions.isPresent() && this.damageConditions.get().isSatisfied(i, d, j, f);
            if (!bl3 && !bl4 && !bl5) continue;
            float k = (float)e + (float)Mth.floor((double)(j * (double)this.damageMultiplier));
            bl |= s.pierce(slot, entity, k, bl5, bl4, bl3);
        }
    }

    public record Condition(int maxDurationTicks, float minSpeed, float minRelativeSpeed) {
        public static final Codec<Condition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("max_duration_ticks").forGetter(Condition::maxDurationTicks), (App)Codec.FLOAT.optionalFieldOf("min_speed", (Object)Float.valueOf(0.0f)).forGetter(Condition::minSpeed), (App)Codec.FLOAT.optionalFieldOf("min_relative_speed", (Object)Float.valueOf(0.0f)).forGetter(Condition::minRelativeSpeed)).apply((Applicative)instance, Condition::new));
        public static final StreamCodec<ByteBuf, Condition> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Condition::maxDurationTicks, (StreamCodec)ByteBufCodecs.FLOAT, Condition::minSpeed, (StreamCodec)ByteBufCodecs.FLOAT, Condition::minRelativeSpeed, Condition::new);

        public boolean isSatisfied(int durationTicks, double speed, double relativeSpeed, double minSpeedMultiplier) {
            return durationTicks <= this.maxDurationTicks && speed >= (double)this.minSpeed * minSpeedMultiplier && relativeSpeed >= (double)this.minRelativeSpeed * minSpeedMultiplier;
        }

        public static Optional<Condition> ofMinSpeed(int maxDurationTicks, float minSpeed) {
            return Optional.of(new Condition(maxDurationTicks, minSpeed, 0.0f));
        }

        public static Optional<Condition> ofMinRelativeSpeed(int maxDurationTicks, float minRelativeSpeed) {
            return Optional.of(new Condition(maxDurationTicks, 0.0f, minRelativeSpeed));
        }
    }
}

