/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.notunanancyowen.Spears;
import com.notunanancyowen.components.AttackRange;
import com.notunanancyowen.dataholders.SpearUser;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.EntityHitResult;

public record PiercingWeapon(float hitboxMargin, boolean dealsKnockback, boolean dismounts, Optional<Holder<SoundEvent>> sound, Optional<Holder<SoundEvent>> hitSound) {
    public static final Codec<PiercingWeapon> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Spears.rangedInclusiveFloat(0.0f, 1.0f).optionalFieldOf("hitbox_margin", (Object)Float.valueOf(0.3f)).forGetter(PiercingWeapon::hitboxMargin), (App)Codec.BOOL.optionalFieldOf("deals_knockback", (Object)true).forGetter(PiercingWeapon::dealsKnockback), (App)Codec.BOOL.optionalFieldOf("dismounts", (Object)false).forGetter(PiercingWeapon::dismounts), (App)SoundEvent.CODEC.optionalFieldOf("sound").forGetter(PiercingWeapon::sound), (App)SoundEvent.CODEC.optionalFieldOf("hit_sound").forGetter(PiercingWeapon::hitSound)).apply((Applicative)instance, PiercingWeapon::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PiercingWeapon> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, PiercingWeapon::hitboxMargin, (StreamCodec)ByteBufCodecs.BOOL, PiercingWeapon::dealsKnockback, (StreamCodec)ByteBufCodecs.BOOL, PiercingWeapon::dismounts, (StreamCodec)SoundEvent.STREAM_CODEC.apply(ByteBufCodecs::optional), PiercingWeapon::sound, (StreamCodec)SoundEvent.STREAM_CODEC.apply(ByteBufCodecs::optional), PiercingWeapon::hitSound, PiercingWeapon::new);

    public void playSound(Entity entity) {
        if (entity instanceof Player) {
            Player p = (Player)entity;
            this.sound.ifPresent(sound -> entity.getCommandSenderWorld().playSound(p, entity.getX(), entity.getY(), entity.getZ(), sound, entity.getSoundSource(), 1.0f, 1.0f));
        }
    }

    public void playHitSound(Entity entity) {
        this.hitSound.ifPresent(sound -> entity.getCommandSenderWorld().playSound(null, entity.getX(), entity.getY(), entity.getZ(), sound, entity.getSoundSource(), 1.0f, 1.0f));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canHit(Entity attacker, Entity target) {
        if (!target.canBeHitByProjectile()) return false;
        if (target.isInvulnerable()) return false;
        if (!target.isAlive()) return false;
        if (target instanceof Player) {
            Player playerEntity = (Player)target;
            if (attacker instanceof Player) {
                Player playerEntity2 = (Player)attacker;
                if (!playerEntity2.canHarmPlayer(playerEntity)) return false;
            }
        }
        if (attacker.isPassengerOfSameVehicle(target)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean stab(LivingEntity attacker, EquipmentSlot slot) {
        Level entityHitResult2222;
        ItemStack stack;
        float f = (float)attacker.getAttributeValue(Attributes.ATTACK_DAMAGE);
        boolean bl = false;
        float minReach = 0.0f;
        float maxReach = 3.0f;
        Object object = attacker.getItemBySlot(slot).get(Spears.ATTACK_RANGE);
        if (object instanceof AttackRange) {
            AttackRange attackRange = (AttackRange)object;
            try {
                float f2;
                float reachMin = f2 = attackRange.minReach();
                float reachMax = f2 = attackRange.maxReach();
                minReach = reachMin;
                maxReach = reachMax;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (attacker instanceof SpearUser) {
            SpearUser s = (SpearUser)attacker;
            for (EntityHitResult entityHitResult2222 : Spears.collectPiercingCollisions(attacker, minReach, maxReach, this.hitboxMargin, entity -> PiercingWeapon.canHit((Entity)attacker, entity))) {
                bl |= s.pierce(slot, entityHitResult2222.getEntity(), f, true, this.dealsKnockback, this.dismounts);
            }
        }
        if (!(stack = attacker.getItemBySlot(slot)).isEmpty() && (entityHitResult2222 = attacker.level()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)entityHitResult2222;
            ItemEnchantments itemEnchantmentsComponent = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
            if (itemEnchantmentsComponent != null && !itemEnchantmentsComponent.isEmpty()) {
                EnchantedItemInUse enchantmentEffectContext = new EnchantedItemInUse(stack, slot, attacker);
                for (Object2IntMap.Entry entry : itemEnchantmentsComponent.entrySet()) {
                    Holder registryEntry = (Holder)entry.getKey();
                    int lvl = EnchantmentHelper.getItemEnchantmentLevel((Holder)registryEntry, (ItemStack)stack);
                    if (!((Enchantment)registryEntry.value()).matchingSlot(slot)) continue;
                    for (ConditionalEffect enchantmentEffectEntry : ((Enchantment)registryEntry.value()).getEffects(Spears.POST_PIERCING_ATTACK)) {
                        LootParams lootContextParameterSet;
                        if (!enchantmentEffectEntry.matches(new LootContext.Builder(lootContextParameterSet = new LootParams.Builder(server).withParameter(LootContextParams.THIS_ENTITY, (Object)attacker).withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)lvl).withParameter(LootContextParams.ORIGIN, (Object)attacker.position()).create(LootContextParamSets.ENCHANTED_ENTITY)).create(Optional.empty()))) continue;
                        ((EnchantmentEntityEffect)enchantmentEffectEntry.effect()).apply(server, lvl, enchantmentEffectContext, (Entity)attacker, attacker.position());
                    }
                }
            }
        }
        if (bl) {
            this.playHitSound((Entity)attacker);
        }
        this.playSound((Entity)attacker);
        attacker.swing(InteractionHand.MAIN_HAND, false);
        return bl;
    }
}

