/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.enchantmentfx;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record ApplyExhaustion(LevelBasedValue amount) implements EnchantmentEntityEffect
{
    public static final MapCodec<ApplyExhaustion> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("amount").forGetter(ApplyExhaustion::amount)).apply((Applicative)instance, ApplyExhaustion::new));

    public void apply(ServerLevel world, int level, EnchantedItemInUse context, Entity user, Vec3 pos) {
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            playerEntity.causeFoodExhaustion(this.amount.calculate(level));
        }
    }

    public MapCodec<ApplyExhaustion> codec() {
        return CODEC;
    }
}

