/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.neoforge;

import com.notunanancyowen.Spears;
import com.notunanancyowen.SpearsClient;
import com.notunanancyowen.components.PiercingWeapon;
import com.notunanancyowen.neoforge.SpearsConfig;
import com.notunanancyowen.packets.PlayerStabC2SPacket;
import com.notunanancyowen.packets.TriggerStabEffectsC2SPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="spears")
public final class SpearsNeoForge {
    public SpearsNeoForge(IEventBus modEventBus, ModContainer modContainer) {
        Spears.init();
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::buildContents);
        modEventBus.addListener(this::registerPayloads);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SpearsConfig.SPEC);
    }

    private void buildContents(BuildCreativeModeTabContentsEvent itemGroup) {
        if (itemGroup.getTabKey() == CreativeModeTabs.COMBAT) {
            itemGroup.insertAfter(Items.NETHERITE_SWORD.getDefaultInstance(), Spears.WOODEN_SPEAR.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            itemGroup.insertAfter(Spears.WOODEN_SPEAR.getDefaultInstance(), Spears.STONE_SPEAR.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            itemGroup.insertAfter(Spears.STONE_SPEAR.getDefaultInstance(), Spears.IRON_SPEAR.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            itemGroup.insertAfter(Spears.IRON_SPEAR.getDefaultInstance(), Spears.GOLDEN_SPEAR.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            itemGroup.insertAfter(Spears.GOLDEN_SPEAR.getDefaultInstance(), Spears.DIAMOND_SPEAR.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            itemGroup.insertAfter(Spears.DIAMOND_SPEAR.getDefaultInstance(), Spears.NETHERITE_SPEAR.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(PlayerStabC2SPacket.ID, PlayerStabC2SPacket.PACKET_CODEC, (packet, context) -> {
            Entity p = packet.getEntity(context.player().level());
            if (p instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)p;
                Object patt0$temp = sp.getMainHandItem().get(Spears.PIERCING_WEAPON);
                if (patt0$temp instanceof PiercingWeapon) {
                    PiercingWeapon pw = (PiercingWeapon)patt0$temp;
                    pw.stab((LivingEntity)sp, EquipmentSlot.MAINHAND);
                }
                sp.resetAttackStrengthTicker();
            }
        });
        registrar.playToServer(TriggerStabEffectsC2SPacket.ID, TriggerStabEffectsC2SPacket.PACKET_CODEC, (packet, context) -> {
            Player patt0$temp;
            if (packet.toggle() && (patt0$temp = context.player()) instanceof ServerPlayer) {
                ServerPlayer s = (ServerPlayer)patt0$temp;
                packet.trigger(s);
            }
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @EventBusSubscriber(modid="spears", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            SpearsClient.sendPacketUniversal = payload -> {
                PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            };
        }
    }
}

