/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.packets;

import com.notunanancyowen.Spears;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public record TriggerStabEffectsC2SPacket(boolean toggle) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, TriggerStabEffectsC2SPacket> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, TriggerStabEffectsC2SPacket::toggle, TriggerStabEffectsC2SPacket::new);
    public static final CustomPacketPayload.Type<TriggerStabEffectsC2SPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"spears", (String)"send_stab_effects_to_server"));

    public void trigger(ServerPlayer me) {
        Level level;
        InteractionHand hand = me.swingingArm == null ? InteractionHand.MAIN_HAND : me.swingingArm;
        ItemStack stack = me.getItemInHand(hand);
        if (!stack.isEmpty() && (level = me.level()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            ItemEnchantments itemEnchantmentsComponent = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
            if (itemEnchantmentsComponent != null && !itemEnchantmentsComponent.isEmpty()) {
                EnchantedItemInUse enchantmentEffectContext = new EnchantedItemInUse(stack, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND, (LivingEntity)me);
                for (Object2IntMap.Entry entry : itemEnchantmentsComponent.entrySet()) {
                    Holder registryEntry = (Holder)entry.getKey();
                    int lvl = EnchantmentHelper.getItemEnchantmentLevel((Holder)registryEntry, (ItemStack)stack);
                    if (!((Enchantment)registryEntry.value()).matchingSlot(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND)) continue;
                    for (ConditionalEffect enchantmentEffectEntry : ((Enchantment)registryEntry.value()).getEffects(Spears.POST_PIERCING_ATTACK)) {
                        LootParams lootContextParameterSet;
                        if (!enchantmentEffectEntry.matches(new LootContext.Builder(lootContextParameterSet = new LootParams.Builder(server).withParameter(LootContextParams.THIS_ENTITY, (Object)me).withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)lvl).withParameter(LootContextParams.ORIGIN, (Object)me.position()).create(LootContextParamSets.ENCHANTED_ENTITY)).create(Optional.empty()))) continue;
                        ((EnchantmentEntityEffect)enchantmentEffectEntry.effect()).apply(server, lvl, enchantmentEffectContext, (Entity)me, me.position());
                    }
                }
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

