/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.spears.mixin;

import com.notunanancyowen.Spears;
import com.notunanancyowen.SpearsClient;
import com.notunanancyowen.components.KineticWeapon;
import com.notunanancyowen.components.SwingAnimation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public abstract class BipedEntityModelMixin<T extends LivingEntity>
extends AgeableListModel<T> {
    @Shadow
    @Final
    public ModelPart rightArm;
    @Shadow
    @Final
    public ModelPart body;
    @Shadow
    @Final
    public ModelPart leftArm;
    @Shadow
    @Final
    public ModelPart head;
    @Shadow
    public HumanoidModel.ArmPose rightArmPose;
    @Shadow
    public HumanoidModel.ArmPose leftArmPose;

    @Shadow
    protected abstract ModelPart getArm(HumanoidArm var1);

    @Inject(method={"poseRightArm(Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void rightArmSpear(T entity, CallbackInfo ci) {
        if ((!this.rightArmPose.isTwoHanded() || this.attackTime > 0.0f) && this.spears$handleSpearAnimationPerArm(entity, HumanoidArm.RIGHT) && !entity.isUsingItem() && this.attackTime > 0.0f) {
            ci.cancel();
        }
    }

    @Inject(method={"poseLeftArm(Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void leftArmSpear(T entity, CallbackInfo ci) {
        if ((!this.leftArmPose.isTwoHanded() || this.attackTime > 0.0f) && this.spears$handleSpearAnimationPerArm(entity, HumanoidArm.LEFT) && !entity.isUsingItem() && this.attackTime > 0.0f) {
            ci.cancel();
        }
    }

    @Unique
    private boolean spears$handleSpearAnimationPerArm(T entity, HumanoidArm arm) {
        KineticWeapon kineticWeaponComponent;
        SwingAnimation s;
        ItemStack itemStack = entity.getMainArm() == arm ? entity.getMainHandItem() : entity.getOffhandItem();
        Object object = itemStack.get(Spears.SWING_ANIMATION);
        if (!(object instanceof SwingAnimation && (s = (SwingAnimation)object).swingType().equals("stab") || itemStack.is(Spears.SPEARS) && this.attackTime <= 0.0f)) {
            return false;
        }
        ModelPart usedArm = this.getArm(arm);
        usedArm.yRot = -0.1f * this.head.yRot;
        usedArm.xRot = -1.5707964f + this.head.xRot + 0.8f;
        if (entity.isFallFlying() || entity.getSwimAmount(1.0f) > 0.0f) {
            usedArm.xRot -= 0.9599311f;
        }
        if (entity.isUsingItem() && (kineticWeaponComponent = (KineticWeapon)itemStack.get(Spears.KINETIC_WEAPON)) != null) {
            int i = arm == HumanoidArm.RIGHT ? 1 : -1;
            SpearsClient.holdUpAnimation lv = SpearsClient.holdUpAnimation.play(kineticWeaponComponent, (float)entity.getTicksUsingItem() + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true));
            usedArm.yRot += (float)(-i) * lv.swayScaleFast() * ((float)Math.PI / 180) * lv.swayIntensity();
            usedArm.zRot += (float)(-i) * lv.swayScaleSlow() * ((float)Math.PI / 180) * lv.swayIntensity() * 0.5f;
            usedArm.xRot += (float)Math.PI / 180 * (-40.0f * lv.raiseProgressStart() + 30.0f * lv.raiseProgressMiddle() + -20.0f * lv.raiseProgressEnd() + 20.0f * lv.lowerProgress() + 10.0f * lv.raiseBackProgress() + 0.6f * lv.swayScaleSlow() * lv.swayIntensity());
        }
        return true;
    }

    @Inject(method={"setupAttackAnimation(Lnet/minecraft/world/entity/LivingEntity;F)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Mth;sin(F)F", ordinal=3)}, cancellable=true)
    private void addSpearAnimation(T entity, float animationProgress, CallbackInfo ci) {
        Object object = entity.getMainHandItem().get(Spears.SWING_ANIMATION);
        if (object instanceof SwingAnimation) {
            SwingAnimation s = (SwingAnimation)object;
            if (s.swingType().equals("none")) {
                ci.cancel();
                return;
            }
            if (s.swingType().equals("stab")) {
                float f = entity.isUsingItem() ? 1.0f : this.attackTime;
                HumanoidArm arm = entity.getMainArm();
                this.rightArm.yRot -= this.body.yRot;
                this.leftArm.yRot -= this.body.yRot;
                this.leftArm.xRot -= this.body.yRot;
                float g = -(Mth.cos((float)((float)Math.PI * Mth.clamp((float)Mth.inverseLerp((float)f, (float)0.0f, (float)0.05f), (float)0.0f, (float)1.0f))) - 1.0f) / 2.0f;
                float h = Mth.clamp((float)Mth.inverseLerp((float)f, (float)0.05f, (float)0.2f), (float)0.0f, (float)1.0f);
                h *= h;
                float i = Mth.clamp((float)Mth.inverseLerp((float)f, (float)0.4f, (float)1.0f), (float)0.0f, (float)1.0f);
                i = i < 0.5f ? (i == 0.0f ? 0.0f : (float)(Math.pow(2.0, 20.0 * (double)i - 10.0) / 2.0)) : (i == 1.0f ? 1.0f : (float)((2.0 - Math.pow(2.0, -20.0 * (double)i + 10.0)) / 2.0));
                this.getArm((HumanoidArm)arm).xRot += (90.0f * g - 120.0f * h + 30.0f * i) * ((float)Math.PI / 180);
                ci.cancel();
            }
        }
    }

    @Inject(method={"setupAttackAnimation(Lnet/minecraft/world/entity/LivingEntity;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void animateLanceAttack(T entity, float animationProgress, CallbackInfo ci) {
        Object object = (entity.isUsingItem() ? entity.getUseItem() : entity.getMainHandItem()).get(Spears.KINETIC_WEAPON);
        if (object instanceof KineticWeapon) {
            KineticWeapon k = (KineticWeapon)object;
            if (entity.isUsingItem()) {
                float g;
                float f = (float)entity.getTicksUsingItem() + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
                float f2 = g = k.delayTicks() == 0 ? 1.0f : (float)k.delayTicks();
                if (f > (float)k.getUseTicks()) {
                    if ((f = (1.0f - (f - (float)k.getUseTicks())) / g) < 0.0f) {
                        f = 0.0f;
                    }
                } else if ((f /= g) > 1.0f) {
                    f = 1.0f;
                }
                ModelPart usedArm = this.getArm(entity.getUsedItemHand() == InteractionHand.MAIN_HAND ? entity.getMainArm() : entity.getMainArm().getOpposite());
                usedArm.yRot = (float)Math.clamp((double)this.head.yRot, -1.3089969389957472, 1.3089969389957472) * f;
                usedArm.xRot = usedArm.xRot + (this.head.xRot * 0.5f * f - (float)(Math.PI / 180 * (entity.isFallFlying() || entity.getSwimAmount(1.0f) > 0.0f ? 55.0 : 30.0)) * f);
                ci.cancel();
            }
        }
    }
}

