/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.spears.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.authlib.GameProfile;
import com.notunanancyowen.Spears;
import com.notunanancyowen.SpearsClient;
import com.notunanancyowen.components.UseEffects;
import com.notunanancyowen.packets.TriggerStabEffectsC2SPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class})
public abstract class ClientPlayerEntityMixin
extends Player {
    @Shadow
    public Input input;
    @Shadow
    @Final
    protected Minecraft minecraft;

    public ClientPlayerEntityMixin(Level world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"aiStep()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isUsingItem()Z", shift=At.Shift.AFTER)})
    private void removeMovementSpeedPenalty(CallbackInfo ci) {
        Object object;
        if (this.getUseItem() != null && (object = this.getUseItem().getComponents().get(Spears.USE_EFFECTS)) instanceof UseEffects) {
            UseEffects u = (UseEffects)object;
            float f = 5.0f * u.strafeSpeed();
            this.input.forwardImpulse *= f;
            this.input.leftImpulse *= f;
        }
    }

    @ModifyExpressionValue(method={"canStartSprinting()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isUsingItem()Z")})
    private boolean makeSurePlayerCanSprint(boolean original) {
        UseEffects u;
        Object object;
        if (this.getUseItem() != null && (object = this.getUseItem().getComponents().get(Spears.USE_EFFECTS)) instanceof UseEffects && (u = (UseEffects)object).allowSprinting()) {
            return false;
        }
        return original;
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void triggerOnSwingEffects(CallbackInfo ci) {
        if (Spears.hasBetterCombat && this.minecraft.getConnection() != null) {
            try {
                Object object;
                if (SpearsClient.getUpswingTicks == null) {
                    SpearsClient.getUpswingTicks = Minecraft.class.getDeclaredMethod("getUpswingTicks", new Class[0]);
                }
                if ((object = SpearsClient.getUpswingTicks.invoke((Object)this.minecraft, new Object[0])) instanceof Integer) {
                    Integer i = (Integer)object;
                    if (i > SpearsClient.lastUpswingTicksForBetterCombat) {
                        SpearsClient.sendPacketUniversal.apply(new TriggerStabEffectsC2SPacket(true));
                    }
                    SpearsClient.lastUpswingTicksForBetterCombat = i;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

