/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.spears.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.notunanancyowen.Spears;
import com.notunanancyowen.SpearsClient;
import com.notunanancyowen.components.KineticWeapon;
import com.notunanancyowen.components.SwingAnimation;
import com.notunanancyowen.dataholders.SpearUser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandLayer.class})
public abstract class HeldItemFeatureRendererMixin {
    @Inject(method={"renderArmWithItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;Lnet/minecraft/world/entity/HumanoidArm;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ItemInHandRenderer;renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V")})
    private void addSpearAnimation(LivingEntity entity, ItemStack stack, ItemDisplayContext transformationMode, HumanoidArm arm, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo ci) {
        Object f3;
        SwingAnimation s;
        Object object;
        if (entity.attackAnim > 0.0f && entity.getMainArm() == arm && (object = stack.get(Spears.SWING_ANIMATION)) instanceof SwingAnimation && (s = (SwingAnimation)object).swingType().equals("stab")) {
            float f2;
            Object object2 = stack.get(Spears.KINETIC_WEAPON);
            if (object2 instanceof KineticWeapon) {
                KineticWeapon k = (KineticWeapon)object2;
                f2 = k.forwardMovement();
            } else {
                f2 = 0.0f;
            }
            float f3 = f2;
            float g = 0.125f;
            float h = entity.isUsingItem() ? 1.0f : entity.getAttackAnim(Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true));
            float i = Mth.clamp((float)Mth.inverseLerp((float)h, (float)0.05f, (float)0.2f), (float)0.0f, (float)1.0f);
            i *= i;
            float j = Mth.clamp((float)Mth.inverseLerp((float)h, (float)0.4f, (float)1.0f), (float)0.0f, (float)1.0f);
            j = j < 0.5f ? (j == 0.0f ? 0.0f : (float)(Math.pow(2.0, 20.0 * (double)j - 10.0) / 2.0)) : (j == 1.0f ? 1.0f : (float)((2.0 - Math.pow(2.0, -20.0 * (double)j + 10.0)) / 2.0));
            matrices.rotateAround(Axis.XN.rotationDegrees(70.0f * (i - j)), 0.0f, -g, g);
            matrices.translate(0.0f, f3 * (i - j), 0.0f);
        }
        if (entity.getUseItem().equals(stack) && (f3 = stack.get(Spears.KINETIC_WEAPON)) instanceof KineticWeapon) {
            KineticWeapon k = (KineticWeapon)f3;
            float tickDelta = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            float f4 = (float)stack.getUseDuration(entity) - ((float)entity.getUseItemRemainingTicks() - tickDelta + 1.0f);
            if (f4 == 0.0f || !entity.isUsingItem()) {
                return;
            }
            SpearsClient.holdUpAnimation lv = SpearsClient.holdUpAnimation.play(k, f4);
            int i = arm == HumanoidArm.RIGHT ? 1 : -1;
            float g = 1.0f - lv.raiseProgress() - 1.0f;
            g = 1.0f - (1.0f + 2.70158f * g * g * g + 1.70158f * Mth.square((float)g));
            float j = 0.0f;
            if (entity instanceof SpearUser) {
                SpearUser s2 = (SpearUser)entity;
                j = s2.getTimeSinceLastKineticAttack(tickDelta);
            }
            j = 1.0f - Mth.square((float)Mth.square((float)(1.0f - Mth.clamp((float)Mth.inverseLerp((float)j, (float)1.0f, (float)3.0f), (float)0.0f, (float)1.0f)))) + (Mth.cos((float)((float)Math.PI * Mth.clamp((float)Mth.inverseLerp((float)j, (float)3.0f, (float)10.0f), (float)0.0f, (float)1.0f))) - 1.0f) / 2.0f;
            if ((j *= 0.4f) >= 10.0f) {
                j = 0.0f;
            }
            matrices.translate(0.0, (double)(-j) * 0.4, (double)(-k.forwardMovement() * (g - lv.raiseBackProgress()) + j));
            matrices.rotateAround(Axis.XN.rotationDegrees(lv.raiseProgress() * 70.0f - lv.raiseBackProgress() * 70.0f), 0.0f, -0.03125f, 0.125f);
            matrices.rotateAround(Axis.YP.rotationDegrees(lv.raiseProgress() * (float)i * 90.0f - lv.swayProgress() * (float)i * 90.0f), 0.0f, 0.0f, 0.125f);
        }
    }
}

